'use strict';

angular.module('genisis').service('user', ['api', 'session', '$location',
  '$rootScope',
  function ($api, $session, $location, $rootScope) {
    //try to load an existing user session
    var _user = $session.get('user');

    /**
     * Return the user  object
     * @return Object the user's info
     **/
    this.info = function () {
      return _user;
    };

    /**
     * Login
     * @param string email
     * @param string password
     * @return boolean login status
     **/
    this.login = function (email) {

      var payload = {
        value: email,
        context: 'email',
        data: null
      };

      return $api.retrieve('users', payload).then(
        function (request) {
          if (request && request.success) {

            //update the user object with the api payload
            _user = request.response;

            //save the user session
            $session.set('user', _user);

            $location.path('/requests');
            $location.replace();
            return true;
          } else if (request && request.message) {
            $rootScope.errors.push(request.message);
          } else {
            $rootScope.errors.push('Invalid API Response');
          }

          return false;
        }
      );
    };

    /**
     * Logging out of GenISIS system
     * Clear user session and redirect to the login page
     **/
    this.logout = function () {
      $session.delete();
      _user = {};
      $location.path('/');
    };

    /**
     * Return the name of the user id
     * @return int user id number
     **/
    this.id = function () {
      return _user.id;
    };

    /**
     * Return the name of the user
     * @return string first and last name
     **/
    this.name = function () {
      return _user.firstName + ' ' + _user.lastName;
    };

    /**
     * Figure out if this user is logged in or not
     * @return boolean valid user data
     **/
    this.loggedIn = function () {
      if (_user.id !== undefined) {
        return true;
      }

      return false;
    };

    /**
     * Return the role of this user
     * @return string user's role
     **/
    this.permissions = function () {
      return _user.role;
    };

    /**
     * Check if the user is a researcher
     * @return boolean
     **/
    this.researcher = function () {
      return _user.role === 'researcher' ? true : false;
    };

    /**
     * Check if the user is a data manager
     * @return boolean
     **/
    this.dataManager = function () {
      return _user.role === 'manager' ? true : false;
    };

    /**
     * Check if the user is a admin
     * @return boolean
     **/
    this.admin = function () {
      return _user.role === 'admin' ? true : false;
    };
  }
]);