'use strict';

angular.module('genisis').service('session', ['$cookies',
  function ($cookies) {

    /**
     * Set a value on the genisis session object
     * @param string key property to set on the object
     * @param mixed value what to set in the object property
     * @return object session data
     **/
    this.set = function (key, value) {
      var session = {};
      var expiration = 24 * 60 * 60 * 1000; //one day
      var options = {
        expires: new Date(new Date().getTime() + expiration)
      };

      if ($cookies.get('genisis')) {
        session = JSON.parse($cookies.get('genisis'));
      }

      if (key && value) {
        session[key] = value;
      }

      $cookies.put('genisis', JSON.stringify(session), options);
      return true;
    };

    /**
     * Remove this session value
     * @param string key to the value in the session you want to remove
     * @return boolean
     **/
    this.remove = function (key) {
      var session = {};
      var expiration = 24 * 60 * 60 * 1000; //one day
      var options = {
        expires: new Date(new Date().getTime() + expiration)
      };

      if ($cookies.get('genisis')) {
        session = JSON.parse($cookies.get('genisis'));
      }

      //remove the value for a specific key
      if (key && session && session.hasOwnProperty(key)) {
        delete session[key];
        $cookies.put('genisis', JSON.stringify(session), options);
        return true;
      }

      return false;
    };

    /**
     * Delete the cookie for the user
     **/
    this.delete = function () {

      if ($cookies.get('genisis')) {
        $cookies.remove('genisis');
        return true;
      }

      return false;
    };

    /**
     * Get a genisis session value
     * @param string key property to get on the object
     * @return object specific data or full session data
     **/
    this.get = function (key) {

      var session = {};

      if ($cookies.get('genisis')) {
        session = JSON.parse($cookies.get('genisis'));
      }

      if (key && session && session.hasOwnProperty(key)) {
        return session[key];
      } else if (key) { //empty object if we can't find the property
        return {};
      }

      return session;
    };
  }
]);