'use strict';

describe('services/apiService.js', function () {

  var $api, $rootScope, $scope, $httpBackend, $q, $ENV;

  beforeEach(module('genisis'));

  beforeEach(function () {
    inject(function (api, _$rootScope_, _$httpBackend_, _$q_, ENV) {
      $api = api;
      $rootScope = _$rootScope_;
      $httpBackend = _$httpBackend_;
      $q = _$q_;
      $scope = $rootScope.$new();
      $ENV = ENV;

      $httpBackend.when('GET').respond('test GET http call');

      $rootScope.config = {
        apiURL: '/'
      };
    });
  });

  it('service exists', function () {
    expect($api).not.toBeNull();
  });

  describe('$api.generateConfig() function', function () {
    it('exists', function () {
      expect($api.generateConfig).toBeDefined();
    });

    it('return an object if a value and context are given', function () {

      var method = 'test';
      var endpoint = 'test';
      var data = {
        test: 'data'
      };
      var value = 'test value';
      var context = 'test context';
      var options = {};
      var headers = {};

      var payload = {
        value: value,
        context: context,
        data: data
      };

      expect($api.generateConfig(
        method,
        endpoint,
        payload,
        options,
        headers
      )).toEqual({
        method: method,
        endpoint: endpoint + '/' + value + '/' + context,
        data: data,
        options: options,
        headers: headers
      });
    });

    it('return an object if a value is given', function () {

      var method = 'test';
      var endpoint = 'test';
      var data = {
        test: 'data'
      };
      var value = 'test value';
      var options = {};
      var headers = {};

      var payload = {
        value: value,
        data: data
      };

      expect($api.generateConfig(
        method,
        endpoint,
        payload,
        options,
        headers
      )).toEqual({
        method: method,
        endpoint: endpoint + '/' + value,
        data: data,
        options: options,
        headers: headers
      });
    });

    it('return an object if a context is given', function () {

      var method = 'test';
      var endpoint = 'test';
      var data = {
        test: 'data'
      };
      var context = 'test context';
      var options = {};
      var headers = {};

      var payload = {
        context: context,
        data: data
      };

      expect($api.generateConfig(
        method,
        endpoint,
        payload,
        options,
        headers
      )).toEqual({
        method: method,
        endpoint: endpoint + '/' + context,
        data: data,
        options: options,
        headers: headers
      });
    });
  });

  describe('$api.fetch() function', function () {
    it('exists', function () {
      expect($api.fetch).toBeDefined();
    });

    it('returns a promise', function () {

      var config = {
        method: 'GET',
        endpoint: 'testEndpoint',
        headers: ['application/json'],
        data: {
          test: 'data'
        }
      };

      $api.formatRequest = jasmine.createSpy('formatRequest');

      spyOn($api, 'fetch').and.callFake(function () {
        var deferred = $q.defer();
        deferred.resolve(config);
        return deferred.promise;
      });

      var promise = $api.fetch(config);

      promise.then(function (data) {
        expect(data).toEqual(config);
      });

      $scope.$apply();
    });
  });

  describe('$api.formatRequest() function', function () {
    it('exists', function () {
      expect($api.formatRequest).toBeDefined();
    });

    it('returns request data if status == 200 and there is data',
      function () {
        var sampleRequest = {
          status: 200,
          data: {
            test: 'data'
          }
        };

        expect($api.formatRequest(sampleRequest)).toEqual(
          sampleRequest.data);
      });

    it('returns request an API error if status != 200', function () {
      var sampleRequest = {
        status: 100,
        data: {
          test: 'data'
        }
      };

      var errorRequest = {
        success: false,
        message: 'API request error',
        apiResponse: sampleRequest
      };

      expect($api.formatRequest(sampleRequest)).toEqual(
        errorRequest);
    });

    it('returns request an API error if there is no data', function () {
      var sampleRequest = {
        status: 200,
        data: null
      };

      var errorRequest = {
        success: false,
        message: 'API request error',
        apiResponse: sampleRequest
      };

      expect($api.formatRequest(sampleRequest)).toEqual(
        errorRequest);
    });
  });

  describe('$api.retrieve() function', function () {
    it('exists', function () {
      expect($api.retrieve).toBeDefined();
    });

    it('calls $api.fetch() with method GET', function () {

      $api.fetch = jasmine.createSpy('fetch');

      var generateConfig = {
        method: 'GET',
        endpoint: 'getEndpoint',
        data: null,
        options: null,
        headers: {
          'Content-Type': 'application/json'
        }
      };

      $api.retrieve('getEndpoint');
      expect($api.fetch.calls.count()).toEqual(1);
      expect($api.fetch.calls.allArgs()[0][0]).toEqual(
        generateConfig);
    });
  });

  describe('$api.create() function', function () {
    it('exists', function () {
      expect($api.create).toBeDefined();
    });

    it('calls $api.fetch() with method POST', function () {

      $api.fetch = jasmine.createSpy('fetch');

      var generateConfig = {
        method: 'POST',
        endpoint: 'createEndpoint',
        data: null,
        options: null,
        headers: {
          'Content-Type': 'application/json'
        }
      };

      $api.create('createEndpoint');
      expect($api.fetch.calls.count()).toEqual(1);
      expect($api.fetch.calls.allArgs()[0][0]).toEqual(
        generateConfig);
    });
  });

  describe('$api.update() function', function () {
    it('exists', function () {
      expect($api.update).toBeDefined();
    });

    it('calls $api.fetch() with method PUT', function () {

      $api.fetch = jasmine.createSpy('fetch');

      var generateConfig = {
        method: 'PUT',
        endpoint: 'updateEndpoint',
        data: null,
        options: null,
        headers: {
          'Content-Type': 'application/json'
        }
      };

      $api.update('updateEndpoint');
      expect($api.fetch.calls.count()).toEqual(1);
      expect($api.fetch.calls.allArgs()[0][0]).toEqual(
        generateConfig);
    });
  });

  describe('$api.delete() function', function () {
    it('exists', function () {
      expect($api.delete).toBeDefined();
    });

    it('calls $api.fetch() with method DELETE', function () {

      $api.fetch = jasmine.createSpy('fetch');

      var generateConfig = {
        method: 'DELETE',
        endpoint: 'deleteEndpoint',
        data: null,
        options: null,
        headers: {
          'Content-Type': 'application/json'
        }
      };

      $api.delete('deleteEndpoint');
      expect($api.fetch.calls.count()).toEqual(1);
      expect($api.fetch.calls.allArgs()[0][0]).toEqual(
        generateConfig);
    });
  });
});