'use strict';

describe('login/login.js', function () {

  beforeEach(module('genisis'));

  var $controller, $scope, $rootScope, $user, $location;

  beforeEach(
    inject(function (_$controller_, _user_, _$location_) {
      $controller = _$controller_;
      $user = _user_;
      $location = _$location_;
      $rootScope = {};
      $scope = {};

      spyOn($location, 'path');
      spyOn($user, 'loggedIn').and.returnValue(true);
      spyOn($user, 'login');

      $controller('loginCtrl', {
        $scope: $scope,
        $rootScope: $rootScope,
        $user: $user,
        $location: $location
      });
    })
  );

  it('navigates to /requests when user is logged in', function () {
    expect($location.path.calls.count()).toEqual(1);
    expect($location.path.calls.first().args).toEqual(['/requests']);
  });

  describe('$scope.login() function', function () {

    it('exists', function () {
      expect($scope.login).toBeDefined();
    });

    it('pushes error to $rootScope.errors when email is invalid',
      function () {
        var formValidation = {
          email: {
            $invalid: true
          },
          password: {
            $invalid: false
          }
        };

        $scope.login(formValidation);
        expect($rootScope.errors).toEqual(
          ['You must enter a valid email address.']
        );
      });

    it('pushes error to $rootScope.errors when password is invalid',
      function () {
        var formValidation = {
          email: {
            $invalid: false
          },
          password: {
            $invalid: true
          }
        };

        $scope.login(formValidation);
        expect($rootScope.errors).toEqual([
          'You must enter a valid password.'
        ]);
      });

    it(
      'pushes errors to $rootScope.errors when email and password is invalid',
      function () {
        var formValidation = {
          email: {
            $invalid: true
          },
          password: {
            $invalid: true
          }
        };

        $scope.login(formValidation);
        expect($rootScope.errors).toEqual(
          [
            'You must enter a valid email address.',
            'You must enter a valid password.'
          ]
        );
      }
    );

    it('calls $user.login() when email and password are valid',
      function () {
        var formValidation = {
          email: {
            $invalid: false
          },
          password: {
            $invalid: false
          }
        };

        $scope.login(formValidation);
        expect($user.login).toHaveBeenCalled();
      });
  });
});