'use strict';

describe('core/run.js', function () {

  beforeEach(module('genisis'));

  it('has $rootScope.validateRoute() function', function () {
    inject(function ($rootScope) {

      //the function exists
      expect($rootScope.validateRoute).toBeDefined();

      //routingTo is undefined
      expect($rootScope.validateRoute()).toEqual(false);

      //routingTo/$$route is undefined
      var routingTo = {};
      expect($rootScope.validateRoute(routingTo)).toEqual(false);

      //originalPath missing or invalid
      routingTo = {
        '$$route': {
          'originalPath': null
        }
      };
      expect($rootScope.validateRoute(routingTo)).toEqual(false);

      //originalPath valid
      routingTo = {
        '$$route': {
          'originalPath': '/'
        }
      };
      expect($rootScope.validateRoute(routingTo)).toEqual(true);

      //Event is not undefined, preventDefault
      expect($rootScope.validateRoute(routingTo, new Event())).toEqual(
        true);

      //User is not logged in and trying to go somewhere besides the login page
      routingTo = {
        '$$route': {
          'originalPath': '/dashboard'
        }
      };

      expect(
        $rootScope.validateRoute(routingTo, new Event())
      ).toEqual(false);

    });
  });

  it('calls $rootScope.validateRoute() on $routeChangeStart', function () {
    inject(function ($rootScope) {
      $rootScope.validateRoute = jasmine.createSpy('validateRoute');
      $rootScope.$broadcast('$routeChangeStart');
      expect($rootScope.validateRoute).toHaveBeenCalled();
    });
  });
});