'use strict';

angular.module('genisis').run(
  ['$rootScope', '$location', 'user', '$route',
    function ($rootScope, $location, $user, $route) {

      $rootScope.validateRoute = function (routingTo, event) {
        var validRoute = false;

        //send them back to the index page if routingTo or
        //the $$route is undefined
        if (routingTo === undefined || routingTo.$$route === undefined) {
          $location.path('/');
          $location.replace();
          return false;
        }

        //make sure this is a valid route
        if (Object.keys($route.routes)
          .indexOf(routingTo.$$route.originalPath) !== -1
        ) {
          validRoute = true;
        }

        //not a valid route, don't bother seeing if they're logged in or not
        if (!validRoute) {
          $location.path('/');
          $location.replace();
          return false;
        }

        //routeChangeStart triggered, prevent route change
        //if they're not logged in
        if (routingTo !== undefined &&
          event !== undefined &&
          routingTo.$$route.originalPath &&
          routingTo.$$route.originalPath !== '/' &&
          !$user.loggedIn()
        ) {
          event.preventDefault();
          $location.path('/');
          $location.replace();
          return false;
        }

        return true;
      };

      //force them back to the login page if they're not currently logged in
      $rootScope.$on('$routeChangeStart', function (event, routingTo) {
        $rootScope.validateRoute(routingTo, event);
      });
    }
  ]);