'use strict';

describe('core/app.js', function () {

  var app;
  var $route;

  beforeEach(function () {
    app = module('genisis');
  });

  beforeEach(inject(function (_$route_) {
    $route = _$route_;
  }));

  it('creates the genisis module', function () {
    expect(app).not.toBeNull();
  });

  describe('$routeProvider', function () {

    it('has route /createRequest', function () {
      expect($route.routes['/createRequest']).toBeDefined();
      expect($route.routes['/createRequest'].templateUrl)
        .toEqual('requests/createRequest.html');
    });

    it('has route /dashboard', function () {
      expect($route.routes['/dashboard']).toBeDefined();
      expect($route.routes['/dashboard'].templateUrl)
        .toEqual('dashboard/dashboard.html');
    });

    it('has route /requests', function () {
      expect($route.routes['/requests']).toBeDefined();
      expect($route.routes['/requests'].templateUrl)
        .toEqual('requests/requests.html');
    });

    it('has route /requests/:id', function () {
      expect($route.routes['/requests/:id']).toBeDefined();
      expect($route.routes['/requests/:id'].templateUrl)
        .toEqual('requests/editRequest.html');
    });

    it('has route /studyApprovals', function () {
      expect($route.routes['/studyApprovals']).toBeDefined();
      expect($route.routes['/studyApprovals'].templateUrl)
        .toEqual('studies/studyApproval.html');
    });

    it('has route /studyApprovals/:id', function () {
      expect($route.routes['/studyApprovals/:id']).toBeDefined();
      expect($route.routes['/studyApprovals/:id'].templateUrl)
        .toEqual('studies/editStudyApproval.html');
    });

    it('has route /createStudy', function () {
      expect($route.routes['/createStudy']).toBeDefined();
      expect($route.routes['/createStudy'].templateUrl)
        .toEqual('studies/createStudyApproval.html');
    });

    it('has route /', function () {
      expect($route.routes['/']).toBeDefined();
      expect($route.routes['/'].templateUrl)
        .toEqual('login/login.html');
    });
  });
});