require 'rails_helper'
require 'rake'

DrTurboTax::Application.load_tasks

describe "assign missing spec_ids to EvaluationSpecs", cui: true do
  before do
    @short_spec1 = create(:short_spec01)
    @no_id_short_spec = create(:no_id_short_spec)
  end

  it "should assign a spec_id to an EvaluationSpec that has none, if it has a spec" do
    expect(EvaluationSpec.last.spec_id).to eq ""
    Rake::Task['eval_specs:assign_missing_specids'].reenable
    Rake::Task['eval_specs:assign_missing_specids'].invoke
    expect(EvaluationSpec.last.spec_id).to_not eq ""
    expect(EvaluationSpec.last.spec_id.size).to eq 40
  end

  it "should not change the spec_id of an EvaluationSpec that already has one" do
    expect(EvaluationSpec.first.spec_id).to eq "4e2f2e14ad7d1ec57c4652d8114d7a08266d0e7f"
    Rake::Task['eval_specs:assign_missing_specids'].reenable
    Rake::Task['eval_specs:assign_missing_specids'].invoke
    expect(EvaluationSpec.first.spec_id).to eq "4e2f2e14ad7d1ec57c4652d8114d7a08266d0e7f"
  end

end
