require 'rails_helper'

require 'via_api.rb'

RSpec.describe 'VIA_API::EmrService', cpp: true do

  before do
    login_via_response = Rails.root.join("spec/support/via_api/login_via_response.xml").read
    get_consults_for_patient_response = Rails.root.join("spec/support/via_api/get_consults_for_patient_response.xml").read
    url  = VIA_API::VIA_EMR_ENDPOINT_URL
    login_url = VIA_API::VIA_EMR_ENDPOINT_URL
    stub_request(:post, login_url).with { |request| request.body.include?("loginVIA") }.to_return(status: 200, body: login_via_response)
    stub_request(:post, url).with { |request| request.body.include?("getConsultsForPatient") }.to_return(status: 200, body: get_consults_for_patient_response)

    @test_patient = VIA_API::Models::Veteran.new( {:first_name=>"FAITH",
                                               :middle_name=>"K",
                                               :last_name=>"AARSVOLD",
                                               :date_of_birth=>"07/16/1942",
                                               :address=>["712 S OAK",nil,nil],
                                               :city=>"KIMBALL",
                                               :county=>"65",
                                               :state=>"NEBRASKA",
                                               :zip=>"69145",
                                               :ssn=>"101012294",
                                               :gender=>"F",
                                               :age=>"74",
                                               :marital_status=>"MARRIED",
                                               :patient_name=>"AARSVOLD,FAITH K",
                                               :mpi_pid=>"1009609054",
                                               :mpi_checksum=>"897943",
                                               :local_pid=>"7177262",
                                               :location=>{:id=>"80", :name=>"C SURGERY", :specialty=>{:text=>"4"}, :room=>"2112", :bed=>"1", :ask_for_check_in=>false},
                                               :cwad=>"AD",
                                               :restricted=>false,
                                               :admit_timestamp=>"20160609.165547",
                                               :service_connected=>false,
                                               :sc_percent=>"0",
                                               :inpatient=>false,
                                               :confidentiality=>{:tag=>"0"},
                                               :needs_means_test=>false,
                                               :patient_flags=>{:count=>"0"},
                                               :cmor_site_id=>"442",
                                               :active_insurance=>
                                                "Pt Insur^Patient has active Insurance^\nCompany ID:                   7168777.868\nCompany Name:                 BLUE CROSS/BS WY\nCompany Address:              PO BOX 2266\n                              CHEYENNE, WYOMING 82003-2266\nPhone Number:                 634-1393\nCoordination of Benefits:     PRIMARY insurer\nPolicy Name:                  6033 - KIESOW\nPolicy Reimbursable:          YES\nEffective Date:               Jan 01, 1995\nExpiration Date:              \nSubscriber Relationship to Patient:     SPOUSE\nSubscriber Name:                        AARSVOLD,ELI\nSubscriber ID:                          R026770010\nPharmacy Coverage:            NO\nOutpatient Coverage:          YES\nInpatient Coverage:           YES\nGroup Number:                 GRP NUM 6033\nPatient Relationship to Subscriber:     SPOUSE",
                                               :is_test_patient=>false,
                                               :has_insurance=>false,
                                               :patient_type=>"NON-VETERAN (OTHER)",
                                               :is_veteran=>false,
                                               :is_locally_assigned_mpi_pid=>false,
                                               :sites=>{:count=>"1", :sites=>{:site_to=>{:sitecode=>"516", :name=>"Bay Pines, FL"}}},
                                               :team=>{:attending_name=>"AUDELHUK,CECILIA C", :name=>"GREEN TEAM"}} )
    params = { access_code: "access", verify_code: "verify", site_code: "site" }
    @vista_session = { vista: VIA_API.authenticate(params)}

  end

  describe 'methods', cpp: true do
    it 'Performs the get_consults_for_patient operation' do
      response = VIA_API::EmrService.get_consults_for_patient(@test_patient, @vista_session[:vista])
      expect(response.first.title).to eq("PROSTHETICS REQUEST Cons")
      expect(response.first.status).to eq("Complete")
    end
  end
end
