require 'rails_helper'
require 'mvi.rb'

RSpec.describe MVI::ProcessRetrievePersonResponse, cui: true do 

  context 'Methods' do 
      before do 
        url = MVI::MVI_ENDPOINT_URL
        response = File.read(Rails.root.join("spec/support/mvi/1306_pid_12937191.xml"))
        stub_request(:post, url).to_return(status: 200, body: response)
        site = Site.find(4)
    
        request_id = "MCI-CUI-" + SecureRandom.hex(7)
        person_data = MVI.retrieve_person("12937191", request_id)
        @prpr = MVI::ProcessRetrievePersonResponse.new(person_data, "Sam Smith", site)
      end

      it 'responds to get_veteran_sites_list' do 
        vet_sites = @prpr.get_veteran_sites_list

        one_site = vet_sites.include?(["3456", "PI", "556/Captain James A. Lovell Federal Health Care Center", "USVHA", "PCE"])
        expect(one_site).to be(true)
      end

      it 'responds to is_veteran_registered' do 
        vet_registered = @prpr.is_veteran_registered?

        expect(vet_registered).to be(false)
      end

      it 'responds to patient_full_name' do 
        name =  @prpr.patient_full_name

        expect(name).to eql("BEN TEST CHESNEY")
      end

      it 'responds to create_veteran_hash' do 
        vh = @prpr.create_veteran_hash "CUI/4o4lEHsfNRy0Q==", "608"

        expect(vh[:patient_icn]).to eql("1008520438V882204")
        expect(vh[:birth_date]).to eql("19440423")
      end

  end

end