require 'rails_helper'

RSpec.describe 'DAS::ERUD', cui: true do

  before do
    ENV['DAS_API_URL'] = 'https://das-test.va.gov'
  end

  describe '#send_dbq' do
    before do
      url = 'https://das-test.va.gov/ecrud/v1/core/disabilityBenefitsQuestionnaires/transform'
      # request and response .xml files were provided by DAS and not this app
      dbq_response = Rails.root.join('spec/support/ecrud/dbq_response.rb').read
      @stub = stub_request(:post, url).with { |request| request.body.include?('Neck (Cervical Spine) Conditions (0960M-13)') }.to_return(status: 201, body: dbq_response)
    end

    it 'makes a DAS DBQ request' do
      DAS::ECRUD.send_dbq("spec/support/ecrud/dbq_request.xml")
      expect(@stub).to have_been_requested
    end
  end

  describe '#send_event' do
    before do
      url = 'https://das-test.va.gov/ecrud/v1/core/examManagement'

      event_response = '{"document"=>{"id"=>"$ObjectID(5a99a850165eab41d62717b5)", "path"=>"/ecrud/v1/core/examManagement/5a99a850165eab41d62717b5", "uploadDate"=>"$Date(2018-03-02T19:38:56.353Z)"}, "success"=>true}}'
      @stub = stub_request(:post, url).with { |request| request.body.include?('Contractor') }.to_return(status: 201, body: event_response)
    end

    it 'makes a DAS Event request' do
      # request .xml file was provided by DAS and not this app
      xml_body = Rails.root.join('spec/support/ecrud/event_request.xml').read
      DAS::ECRUD.send_event(xml_body)
      expect(@stub).to have_been_requested
    end
  end
end