require 'rails_helper'

RSpec.describe "Contentions", type: :request do
  before do
    @user = create(:examiner)
    @supervisor = create(:supervisor)
    @claim = create :claim
    @contention = create(:contention, history: "Cthulhu", claim_folder_reviewed: true)
    @claim.contentions << @contention
  end

  describe "GET /claims/:claim_id/rejections/new" do
    it "does not allow a non-supervisor to access"

    it "does not allow a supervisor to reject a claim that's not complete"

    context "with a completed claim" do
      before do
        evaluation_spec = create(:evaluation_spec)
        @evaluation = create(:evaluation, user: @user, evaluation_spec: evaluation_spec, doc: build(:diabetes_doc).doc)
        allow_any_instance_of(Evaluation).to receive(:signed?).and_return(true)
        @evaluation.complete! @user
        @claim.evaluations << @evaluation
        @contention.evaluations << @evaluation
        @contention.resolve!(@user)
      end

      it "does not allow a supervisor to reject without an explanation"

      it "allows a supervisor to reject"

      it "shows the proper rejection if rejected multiple times"
    end
  end
end
