require 'rails_helper'

RSpec.describe "Help", :type => :request do

  context "when not logged in" do
    it "should not show a help link on the home page" do
      visit claims_path
      expect(page).to have_no_link "Help", href: pages_help_path
    end

    it "should redirect to the index page if a user tries to go directly to the help page" do
      visit pages_help_path
      expect(page).to have_content "Sign in"
    end
  end

  context "when logged in" do
    before do
      @user = create(:user)
      login_as @user
      visit claims_path
    end

    it "should show a link to help on the homepage"

    it "should show help content"
  end
end
