require 'rails_helper'

RSpec.describe "api/v1/claims", :type => :request do
  before do
    create(:hearing_loss_evaluation_spec)
    create(:elbow_and_forearm_evaluation_spec)
  end

  let(:example_request_sample) { File.open('spec/support/exam_request_sample.xml', 'rb').read }


  context "when the exam is assigned to a user that is not currently in the system" do
    it "should create that user and assign the exam to them"
  end

  context "when the exam is assigned to an existing user" do
    before do
      user = create(:user, first_name: "Mae", last_name: "Jemison", email: "PII      ")
    end

    context "with xml that has a valid claim, contention and evaluations" do
      it "returns a created response status code"

      it "stores a hash of the exam_request data with the claim"

      it "creates a claim for an existing user"

      it "creates a contention for an existing user"

      it "does not create a new user" do
        expect { post api_v1_claims_path, example_request_sample,
               {'CONTENT_TYPE' => 'application/xml'} }.not_to change(User, :count)
      end

      it "should log the ExamRequest"

      context "when there are three evaluations defined in the xml, but only two have CUI evaluation specs" do
        it "creates two evaluations"

        it "creates four log entries"
      end
    end
  end

  context "with invalid xml" do
    let(:invalid_xml) { '<?xml version="1.0" encoding="UTF-8" ?><feed xmlns="http://www.w3.org/2005/Atom" xsi:schemaLocation="http://www.w3.org/2005/Atom http://vler.va.gov/vler/schemas/atom/2005/vler/0.2/atom.xsd" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
</feed>' }

    it "returns an unprocessable entity response status code"

    it "does not create a claim" do
      expect { post api_v1_claims_path, invalid_xml, {'CONTENT_TYPE' => 'application/xml'} }
             .to_not change(Claim, :count)
    end

    it "should log an error"
  end
end
