require 'rails_helper'

RSpec.describe "Form Admin", :type => :request do
  before do
    login_as create(:examiner)
  end

  describe "GET /admin/evaluation_specs" do
    before do
      create(:evaluation_spec)
      create(:diabetes_spec)
    end

    it "should show a list of specs" do
      visit admin_evaluation_specs_path
      expect(page).to have_content "Diabetes milletues evaluation"
      expect(page).to have_content "Simple Yes/No Evaluation"
      expect(page).to have_content "Edit evaluation"
      expect(page).to have_content "Delete evaluation"
      expect(page).to have_content "Add new evaluation"
    end
  end

  describe "GET /admin/evaluation_specs/new" do
    context "when inputting a valid spec" do
      before do
        @evaluation_spec = build(:evaluation_spec)
      end

      it "should show a spec for editing and update it when the user edits it"
    end

    context "when inputting an invalid spec" do
      before do
        @evaluation_spec = build(:invalid_spec)
      end

      it "should display an error message" do
        visit new_admin_evaluation_spec_path
        fill_in "evaluation_spec_spec", with: @evaluation_spec.spec
        click_button 'Create evaluation'
        expect(page).to have_text "Error creating spec:"
        expect(page).to have_text "Could not find required `version` attribute"
      end
    end
  end

  describe "GET /admin/evaluation_specs/:id" do
    before do
      @evaluation_spec = create(:evaluation_spec)
    end

    it "should show the spec" do
      visit admin_evaluation_spec_path(@evaluation_spec)
      expect(page).to have_content "Simple Yes/No Evaluation"
    end
  end

  describe "GET /admin/evaluation_specs/:id/edit" do
    before do
      @evaluation_spec = create(:evaluation_spec)
    end

    context "when updating with a valid spec" do
      it "should show a spec for editing and update it when the user edits it"
    end

    context "when updating then previewing then saving with a valid spec" do
      it "should show a spec for editing and update it when the user edits it"
    end

    context "when updating then previewing then more updating with a valid spec" do
      it "should show a spec for editing and update it when the user edits it"
    end

    context "when updating with an invalid spec" do
      before do
        @invalid_spec = build(:invalid_spec)
      end

      it "show an error message" do
        visit edit_admin_evaluation_spec_path(@evaluation_spec)
        fill_in "evaluation_spec_spec", with: @invalid_spec.spec
        click_button "Save"
        expect(page).to have_text "Error updating spec:"
        expect(page).to have_text "Could not find required `version` attribute"
      end
    end

    context "when updating then previewing with an invalid spec" do
      before do
        @invalid_spec = build(:invalid_spec)
      end

      it "should show an error message and return to edit page" do
        visit edit_admin_evaluation_spec_path(@evaluation_spec)
        fill_in "evaluation_spec_spec", with: @invalid_spec.spec
        click_button "Preview"
        expect(page).to have_text "Invalid Spec:"
        expect(page).to have_text "Editing: Simple Yes/No Evaluation"
      end
    end
  end
end
