require 'rails_helper'

RSpec.describe EndocrineEvaluationPresenter do
  before do
    @user = create(:user)
    claim = create(:claim, date_of_birth: Date.new(1900))
    contention = create(:contention)
    claim.contentions << contention
    @evaluation_spec = EvaluationSpec.create(spec: File.read("app/exams/thyroid-gland-nontoxic-adenoma-of.yml"))
    @evaluation = Evaluation.create(claim: claim, evaluation_spec: @evaluation_spec, user: create(:user))
    allow_any_instance_of(Evaluation).to receive(:to_pdf) { "" }
    contention.evaluations << @evaluation
  end

  context "when the eval is secondary, we output its parent as well" do
    before do
      @claim = create(:claim)
      @claim.contentions << create(:contention, history: "This or That")

      @spec = create(:diabetes_spec)

      @dependent_eval = Evaluation.new(claim: @claim, evaluation_spec: @spec, user: @user)
      @dependent_eval.doc = File.read("spec/evaluations/diabetes.json")
      @claim.contentions.first.evaluations << @dependent_eval

      @parent_eval = Evaluation.new(claim: @claim, evaluation_spec: @spec, completed_at: Time.now, user: @user)
      @parent_eval.doc = File.read("spec/evaluations/diabetes.json")
      @claim.contentions.first.evaluations << @parent_eval

      @dependent_eval.primary_evaluation_id = @parent_eval.id
      @dependent_eval.save

      @evaluation_xml = @dependent_eval.to_xml
    end

    # it "should include the parent eval" do
    #   xml = XML::Document.string(@evaluation_xml)
    #   facts = xml.find("//ef:endocrineFacts")
    #
    #   expect(facts.length).to eq 2
    #
    #   schema_xml = XML::Document.file(Rails.root.join("app/xsd/ExamResponse/exchange/ExamResponse-2.0.xsd").to_s)
    #   schema = XML::Schema.document(schema_xml)
    #   xml.validate_schema(schema)
    # end
  end

  context "when the eval is tertiary, we output all three evals" do
    before do
      @claim = create(:claim)
      @claim.contentions << create(:contention, history: "This or That")

      def spec(title)
        <<-SPEC
    form:
      title: "#{title}"
      id: #{Digest::SHA1.hexdigest title}
      keywords: "Testing Keywords"
      version: "1.0"
      dependent: "Endocrine"
      bodySystem: "Endocrine"
      fieldsets:
        - fieldset:
          - field:
              name: "yesno"
              fieldType: "yes_no"
              label: "bananarama"
              isRequired: true
        SPEC
      end

      @tertiary_spec = create(:diabetes_spec, spec: spec("tertiary"))
      @tertiary_eval = Evaluation.new(claim: @claim, evaluation_spec: @tertiary_spec, user: @user)
      @tertiary_eval.doc = File.read("spec/evaluations/diabetes.json")
      @claim.contentions.first.evaluations << @tertiary_eval

      @secondary_spec = create(:diabetes_spec, spec: spec("secondary"))
      @secondary_eval = Evaluation.new(claim: @claim, evaluation_spec: @secondary_spec, completed_at: Time.now, user: @user)
      @secondary_eval.doc = File.read("spec/evaluations/diabetes.json")
      @claim.contentions.first.evaluations << @secondary_eval

      @primary_spec = create(:diabetes_spec, spec: spec("primary"))
      @primary_eval = Evaluation.new(claim: @claim, evaluation_spec: @primary_spec, completed_at: Time.now, user: @user)
      @primary_eval.doc = File.read("spec/evaluations/diabetes.json")
      @claim.contentions.first.evaluations << @primary_eval

      @tertiary_eval.primary_evaluation_id = @secondary_eval.id
      @tertiary_eval.save

      @secondary_eval.primary_evaluation_id = @primary_eval.id
      @secondary_eval.save

      @evaluation_xml = @tertiary_eval.to_xml
    end

    # it "should include all parent evals" do
    #   xml = Nokogiri::XML(@evaluation_xml)
    #
    #   facts = xml.xpath("//ef:endocrineFacts")
    #
    #   expect(facts.length).to eq 3
    #
    #   tertiary = facts[0]
    #   secondary = facts[1]
    #   primary = facts[2]
    #
    #   expect(tertiary.xpath("ef:endocrineDiagnoses/ef:value").text).to eq "tertiary"
    #   expect(secondary.xpath("ef:endocrineDiagnoses/ef:value").text).to eq "secondary"
    #   expect(primary.xpath("ef:endocrineDiagnoses/ef:value").text).to eq "primary"
    #
    #   expect(secondary.xpath("bsf:dependentDiagnosis").text).to eq "tertiary"
    #   expect(primary.xpath("bsf:dependentDiagnosis").text).to eq "secondary"
    #
    #   # I can't seem to get validation working in nokogiri
    #   xml = XML::Document.string(@evaluation_xml)
    #   schema_xml = XML::Document.file(Rails.root.join("app/xsd/ExamResponse/exchange/ExamResponse-2.0.xsd").to_s)
    #   schema = XML::Schema.document(schema_xml)
    #   xml.validate_schema(schema)
    # end
  end

  context "when there are no symptoms" do
    before do
      @claim = create(:claim)
      @claim.contentions << create(:contention, history: "This or That")

      @spec = create(:diabetes_spec)
      @eval = Evaluation.new(claim: @claim, evaluation_spec: @spec, user: @user)
      @eval.doc = File.read("spec/evaluations/diabetes.json")
      @claim.contentions.first.evaluations << @eval

      @evaluation_xml = @eval.to_xml
    end

    # it "should include a blank Symptoms" do
    #   xml = XML::Document.string(@evaluation_xml)
    #   symptoms = xml.find("//ef:endocrineSymptoms")
    #   expect(symptoms.length).to eq 1
    #   expect(symptoms[0].children.length).to eq 1
    #   expect(symptoms[0].children[0].content).to eq ""
    #
    #   schema_xml = XML::Document.file(Rails.root.join("app/xsd/ExamResponse/exchange/ExamResponse-2.0.xsd").to_s)
    #   schema = XML::Schema.document(schema_xml)
    #   xml.validate_schema(schema)
    # end
  end
end
