module MVIHelper
    def get_attribute_value new_request_doc, tag_name, attribute
      obj = new_request_doc.at_xpath("//href:" + tag_name, "href" => "urn:hl7-org:v3")
      obj["#{attribute}"].nil? ? "NULL_VALUE" : obj["#{attribute}"]
    end

    def substitute_attributes new_request_xml, test_request_xml
      doc = Nokogiri::XML(new_request_xml)

      new_creation_time = get_attribute_value doc, "creationTime", "value"
      new_request_id = get_attribute_value doc, "id", "extension"
      new_query_id = get_attribute_value doc, "queryId", "extension"

      test_doc = Nokogiri::XML(test_request_xml)
      test_doc.at_xpath("//href:creationTime", "href" => "urn:hl7-org:v3")["value"] = new_creation_time
      test_doc.at_xpath("//href:id", "href" => "urn:hl7-org:v3")["extension"] = new_request_id
      test_doc.at_xpath("//href:queryId", "href" => "urn:hl7-org:v3")["extension"] = new_query_id

      doc.to_s
    end

end