# == Schema Information
#
# Table name: symptoms
#
#  id              :integer          not null, primary key
#  name            :string
#  label           :string
#  created_at      :datetime         not null
#  updated_at      :datetime         not null
#  minor_system_id :integer
#  position        :integer
#

require 'rails_helper'

RSpec.describe Symptom, :type => :model, cui: true do
  context "Associations" do
    it { should have_many(:symp_diag_relations).dependent(:delete_all) }
    it { should have_many(:diagnoses).
         through(:symp_diag_relations)
    }
    it { should have_many(:dbq_informations).
         through(:symptoms_dbq_informations).
         dependent(:destroy)
    }
    it { should have_many(:symptoms_dbq_informations) }

    it { should belong_to(:minor_system) }
  end

  context "Validations" do
    subject { create(:symptom) }

    it { should validate_presence_of(:name) }
    it { should validate_uniqueness_of(:name) }
    it { should validate_presence_of(:label) }
  end
end
