require 'rails_helper'

RSpec.describe SupportRequest, :type => :model, cui: true do
  context "Validations" do
    it { should validate_presence_of(:ticket_number) }
    it { should validate_presence_of(:first_name) }
    it { should validate_presence_of(:last_name) }
    it { should validate_presence_of(:customer_organization) }
    it { should validate_presence_of(:customer_site) }
    it { should validate_presence_of(:issue_description) }
    it { should validate_presence_of(:customer_email).
         with_message('Invalid email format.')
    }
    it { should validate_presence_of(:customer_phone).
         with_message('Invalid phone number format.')
    }
  end
end
