# == Schema Information
#
# Table name: referral_statuses
#
#  id                  :integer          not null, primary key
#  name                :string
#  code                :string
#  referral_queue      :string
#  filterable_by_roles :string
#

require 'rails_helper'

RSpec.describe ReferralStatus, :type => :model, cpp: true do

  context "Associations" do
    it { should have_many(:referrals) }
  end

	context "Methods" do

		let(:user) { create(:vha_user) }
		referral_status_new = ReferralStatus.find_by_code('NEW')
		referral_status_assigned = ReferralStatus.find_by_code('ASSIGNED')
		referral_status_review_pending = ReferralStatus.find_by_code('REVIEW_PENDING')

		it "should return true if current user's role status is in filterable_by_user" do
			expect(referral_status_new.filterable_by_user?(user)).to eq true
		end

		it "should return true if current user's role status is in add_to_referral_queue" do
			expect(referral_status_new.add_to_referral_queue?(user)).to eq true
		end

		it "Checks whether referral_status is from NON_VA_ADD_DOC_PHASES"  do
			expect(referral_status_assigned.non_vha_add_document_phase?).to eq true
			expect(referral_status_review_pending.non_vha_add_document_phase?).to eq false
		end

		it "Checks whether referral_status is from VA_REVIEW_CODE"  do
			expect(referral_status_review_pending.vha_valid_for_approve?).to eq true
			expect(referral_status_assigned.vha_valid_for_approve?).to eq false
		end

		it "Checks whether referral_status is from NON_VHA_STATUS_CODES"  do
			expect(referral_status_review_pending.visible_for_non_vha?).to eq true
			expect(referral_status_assigned.visible_for_non_vha?).to eq true
			expect(referral_status_new.visible_for_non_vha?).to eq false
    end

		it "returns the hardcoded 'REVIEW_PENDING' code" do
			expect(ReferralStatus.va_review_phase.code).to eq "REVIEW_PENDING"
		end
	end
end
