# == Schema Information
#
# Table name: referral_notes
#
#  id          :integer          not null, primary key
#  content     :json
#  created_at  :datetime         not null
#  updated_at  :datetime         not null
#  referral_id :integer
#

require 'rails_helper'

RSpec.describe ReferralNote, :type => :model, cpp: true do

  context "Associations" do
    it { should belong_to(:referral) }
  end

  context "Validations" do
    it { should validate_presence_of(:notes) }
  end

  context "methods" do
    let(:referral_note) { create(:referral_note, content: {user: "Joe Bob Billy Boy", notes: "Test Referral Notes XYZ"}) }

    it "should get user from Referral Note content" do
      expect(referral_note.user).to eq("Joe Bob Billy Boy")
    end

    it "should get notes from Referral Note content" do
      expect(referral_note.notes).to eq("Test Referral Notes XYZ")
    end

  end

end
