# == Schema Information
#
# Table name: question_modifiers
#
#  id          :integer          not null, primary key
#  name        :string
#  label       :string
#  mod_type    :string
#  list_values :string           default([]), is an Array
#  html        :text
#  created_at  :datetime         not null
#  updated_at  :datetime         not null
#

require 'rails_helper'

RSpec.describe QuestionModifier, :type => :model, cui: true do
  context "Associations" do
    it { should have_many(:qm_assignments).dependent(:delete_all) }
    it { should have_many(:general_questions).through(:qm_assignments) }
  end

  context "Validations" do
    subject { QuestionModifier.new(name: "example") }

    it { should validate_presence_of(:name) }
    it { should validate_uniqueness_of(:name) }
    it { should validate_presence_of(:mod_type) }
  end
end
