# == Schema Information
#
# Table name: providers_users
#
#  id          :integer          not null, primary key
#  provider_id :integer
#  user_id     :integer
#

require 'rails_helper'

RSpec.describe ProvidersUser, :type => :model, cpp: true do

  context "Associations" do
    it { should belong_to(:provider) }
    it { should belong_to(:user) }
  end

  context "Validations" do
    it "must have non vha user" do
      vha_user = create(:vha_user)
      non_vha_user = create(:community_provider)

      subject = ProvidersUser.new(user: vha_user)
      expect(subject).not_to be_valid

      subject.user = non_vha_user
      expect(subject).to be_valid
    end
  end

  context "methods" do
    before :context do
      @vha_user = create(:vha_user)
      @non_vha_user = create(:community_provider)
      @provider = create(:provider)
    end

    it "should validate a non-vha user" do
      providers_user = ProvidersUser.create(user: @non_vha_user, provider: @provider)
      expect(providers_user).to be_valid
    end

    it "should not validate a vha user" do
      providers_user = ProvidersUser.create(user: @vha_user, provider: @provider)
      expect(providers_user).to be_invalid
    end
  end
end
