require 'rails_helper'

RSpec.describe NpiRegistry, :type => :model, cpp: true do

  context "methods" do

    before do
      body = {"result_count":1, "results":[{"taxonomies": [{"state": "VA", "code": "122300000X", "primary": true, "license": "0401005656", "desc": "Dentist"}], "addresses": [{"city": "GLEN ALLEN", "address_2": "SUITE Q", "telephone_number": "804-270-6808", "fax_number": "804-270-1963", "state": "VA", "postal_code": "23060", "address_1": "10127 WEST BROAD STREET", "country_code": "US", "country_name": "United States", "address_type": "DOM", "address_purpose": "LOCATION"}, {"city": "GLEN ALLEN", "address_2": "SUITE Q", "telephone_number": "804-270-6808", "fax_number": "804-270-1963", "state": "VA", "postal_code": "23060", "address_1": "10124 WEST BROAD STREET", "country_code": "US", "country_name": "United States", "address_type": "DOM", "address_purpose": "MAILING"}], "created_epoch": 1212710400, "identifiers": [{"code": "05", "issuer": "", "state": "VA", "identifier": "010413419", "desc": "MEDICAID"}], "other_names": [], "number": 1922267640, "last_updated_epoch": 1212710400, "basic": {"status": "A", "credential": "DDS", "first_name": "ANNE", "last_name": "ADAMS", "middle_name": "CARTER", "name": "ADAMS ANNE", "sole_proprietor": "YES", "gender": "F", "last_updated": "2008-06-06", "name_prefix": "DR.", "enumeration_date": "2008-06-06"}, "enumeration_type": "NPI-1"}]}.to_json
      stub_request(:get, "#{ENV['URL_FOR_NPI_LOOKUP']}/api?limit=200&number=1922267640").
       to_return(:status => 200, :body => body, :headers => {})
    end

    let(:npi_registry) { build :npi_registry, number: '1922267640'}

    describe "standardize_api(params)" do
      it "standardizes the key npi to number in params" do
        expect(NpiRegistry.standardize_api({npi: "1922267640"})[:number]).to eq npi_registry.number
      end
    end

    describe "search(params)" do

      it "accesses the NpiRegistry web-service and searches for provider using params" do
        expect(NpiRegistry.search({number: "1922267640"})).to be_an_instance_of(Array)
      end
    end

    describe "filter(params)" do

      it "accesses the local database when a web-service call is made only using npi/number" do
        expect(NpiRegistry.filter({number: '1922267640'}).npi).to eq "1922267640"
      end
    end

  end

end
