# == Schema Information
#
# Table name: major_systems
#
#  id                     :integer          not null, primary key
#  name                   :string
#  label                  :string
#  created_at             :datetime         not null
#  updated_at             :datetime         not null
#  evaluation_template_id :integer
#

require 'rails_helper'

RSpec.describe MajorSystem, :type => :model, cui: true do
  context "Associations" do
    it { should have_many(:minor_systems) }

    it { should belong_to(:evaluation_template) }
  end

  context "Validations" do
    it { should validate_presence_of(:name) }
    it { should validate_presence_of(:label) }
  end
end
