# == Schema Information
#
# Table name: general_questions
#
#  id                    :integer          not null, primary key
#  name                  :string
#  label                 :string
#  diagnosis_modifier_id :integer
#  minor_system_id       :integer
#  created_at            :datetime         not null
#  updated_at            :datetime         not null
#  position              :integer
#

require 'rails_helper'

RSpec.describe GeneralQuestion, :type => :model, cui: true do
  context "Associations" do
    it { should have_many(:qm_assignments).
         dependent(:delete_all)
    }
    it { should have_many(:question_modifiers).
         through(:qm_assignments)
    }
    it { should have_many(:dbq_informations).
         through(:general_questions_dbq_informations).
         dependent(:destroy)
    }
    it { should have_many(:general_questions_dbq_informations) }

    it { should belong_to(:minor_system) }
  end

  context "Validations" do
    subject { create(:general_question) }

    it { should validate_presence_of(:name) }
    it { should validate_uniqueness_of(:name) }
    it { should validate_presence_of(:label) }
  end
end
