# == Schema Information
#
# Table name: exam_requesters
#
#  id            :integer          not null, primary key
#  first_name    :string
#  last_name     :string
#  email_address :string
#  primary_phone :integer
#  organization  :string
#

require 'rails_helper'

RSpec.describe ExamRequester, :type => :model, cui: true do
  context "Associations" do
    it { should have_many(:exam_requests) }
  end

  context "Methods" do
    it "#full_name" do
      subject = build_stubbed(:exam_requester, first_name: "first", last_name: "last")
      expect(subject.full_name).to eq("First Last")
    end
  end
end
