# == Schema Information
#
# Table name: diagnoses
#
#  id                    :integer          not null, primary key
#  name                  :string
#  label                 :string
#  code                  :string
#  diagnosis_modifier_id :integer
#  created_at            :datetime         not null
#  updated_at            :datetime         not null
#  minor_system_id       :integer
#

require 'rails_helper'

RSpec.describe Diagnosis, :type => :model, cpp: true do
  context "Associations" do
    it { should have_many(:dm_assignments).
         dependent(:delete_all)
    }
    it { should have_many(:diagnosis_modifiers).
         through(:dm_assignments)
    }
    it { should have_many(:symp_diag_relations).
         dependent(:delete_all)
    }
    it { should have_many(:symptoms).
         through(:symp_diag_relations)
    }
    it { should have_many(:dbq_informations).
         through(:diagnoses_dbq_informations).
         dependent(:destroy)
    }
    it { should have_many(:diagnoses_dbq_informations) }
    it { should belong_to(:minor_system) }
  end

  context "Validations" do
    subject { create(:diagnosis) }
    it { should validate_presence_of(:name) }
    it { should validate_uniqueness_of(:name) }

    it { should validate_presence_of(:label) }
    it { should validate_presence_of(:code) }
  end
end
