# == Schema Information
#
# Table name: diagnosis_modifiers
#
#  id          :integer          not null, primary key
#  name        :string
#  label       :string
#  mod_type    :string
#  list_values :string           default([]), is an Array
#  created_at  :datetime         not null
#  updated_at  :datetime         not null
#

require 'rails_helper'

RSpec.describe DiagnosisModifier, :type => :model, cpp: true do
  context "Associations" do
    it { should have_many(:dm_assignments).
         dependent(:delete_all)
    }
    it { should have_many(:diagnoses).
         through(:dm_assignments)
    }
  end

  context "Validations" do
    subject { DiagnosisModifier.new(name: "example") }

    it { should validate_presence_of(:mod_type) }
    it { should validate_presence_of(:name) }
    it { should validate_uniqueness_of(:name) }
  end
end
