# == Schema Information
#
# Table name: diagnosis_codes
#
#  id           :integer          not null, primary key
#  version_code :string           not null
#  description  :string           not null
#  deleted_at   :datetime
#

require 'rails_helper'

RSpec.describe DiagnosisCode, :type => :model, cpp: true do

  describe "ParanoidModelTest" do
    it_behaves_like 'a Paranoid model'
  end

  context "methods" do
    it "should print the version of the diagnosis code" do
      DiagnosisCode.limit(5).each do |diagnosis_code|
        expect(diagnosis_code.version.length).to eq 2
      end
    end

    it "should print the chapter of the diagnosis code" do
      DiagnosisCode.limit(5).each do |diagnosis_code|
        expect(diagnosis_code.chapter.length).to eq 3
      end
    end

    it "should print the code of the diagnosis code" do
      DiagnosisCode.limit(5).each do |diagnosis_code|
        expect(diagnosis_code.code.length).to eq 6
      end
    end

    it "should return a string of invalid codes in a string separated by comma" do
      DiagnosisCode.limit(5).each do |diagnosis_code|
        expect(DiagnosisCode.validate_codes("#{diagnosis_code.version_code}, 1234string")).to eq "1234string".upcase
      end
    end
  end
end
