# == Schema Information
#
# Table name: clinics
#
#  id                 :integer          not null, primary key
#  site_id            :integer
#  clinic_identifier  :integer
#  name               :string
#  created_at         :datetime         not null
#  updated_at         :datetime         not null
#

require 'rails_helper'

RSpec.describe Clinic, :type => :model, cui: true do
  context "Associations" do
    it { should belong_to(:site) }
  end

  context ".get_clinic_from_user" do
    context "vha user" do
      it "with associated site" do
        user_preferences = UserPreference.new(vista_site_id: 123)
        user = create(:vha_user, user_preference: user_preferences)
        clinic = create(:clinic, site_id: 123)

        expect(Clinic.get_clinic_from_user(user)).to eq(clinic)
      end

      it "no associated site" do
        user_preferences = UserPreference.new(vista_site_id: 123)
        user = create(:vha_user, user_preference: user_preferences)
        clinic = create(:clinic, site_id: 456)

        expect(Clinic.get_clinic_from_user(user)).to be nil
      end
    end

    it "non-vha user" do
      user = create(:community_provider)
      clinic = create(:clinic, site_id: 123)

      expect(Clinic.get_clinic_from_user(user)).to be nil
    end
  end
end
