RSpec.describe VeteranSSN, cui: true do

  context "valid ssn" do
    let(:subject) { VeteranSSN.new(123456789) }

    it "formats with hyphens" do
      expect(subject.formatted).to eq("123-45-6789")
    end

    it "can mask the first 5 digits" do
      expect(subject.masked).to eq("XXX-XX-6789")
    end

    it "can show only the last 4 digits" do
      expect(subject.last_four).to eq("6789")
    end
  end

end
