RSpec.describe SiteClinicsLoader, cui: true do
  let(:subject) { SiteClinicsLoader.new }
  let(:site) { create(:site) }
  let(:vista_session) { double("vista_session") }

  before do
    allow(Site).to receive(:find_by_site_station_number).and_return(site)
  end

  it "puts the site back into the 'initial' state if any errors are raised" do
    allow(VIA_API::SchedulingService).to receive(:get_clinics).and_raise(Exception)

    expect { subject.load!(site, vista_session) }.to raise_error(Exception)
    expect(site.clinics_loaded_state).to eq("initial")
  end

  context "#load!" do
    it "when site is in the initial state" do
      clinics = [
        VIA_API::Models::Clinic.new(id: 123, name: "name1"),
        VIA_API::Models::Clinic.new(id: 234, name: "name2"),
      ]
      allow(VIA_API::SchedulingService).to receive(:get_clinics).and_return(clinics)

      subject.load!(site, vista_session)

      expect(site.clinics.first.clinic_identifier).to eq(123)
      expect(site.clinics.first.name).to eq("name1")

      expect(site.clinics.last.clinic_identifier).to eq(234)
      expect(site.clinics.last.name).to eq("name2")

      expect(site.clinics_loaded_state).to eq("loaded")
    end

    it "returns early when site is already in the loading state" do
      site.clinics_loaded_state = :loading

      subject.load!(site, vista_session)

      expect(site.clinics_loaded_state).to eq("loading")
    end
  end
end
