# == Schema Information
#
# Table name: sites
#
#  id              :integer          not null, primary key
#  name            :string
#  address         :string
#  city            :string
#  state           :string
#  country         :string
#  created_at      :datetime         not null
#  updated_at      :datetime         not null
#  access_requests :string           default([]), is an Array
#  role_requests   :string           default([]), is an Array
#  site_station_number    :string
#  zip_code        :string
#  deleted_at      :datetime
#  clinics_loaded_state     :integer
#

FactoryBot.define do
  factory :site do
    name "QTC"
    address "21700 Copley Dr., Ste 200"
    city "Diamond Bar"
    state "CA"
    country "USA"
    site_station_number "QTC VBA Vendor"
  end

  factory :manchester_va, class: Site do
    name "Manchester VA Medical Center"
    address "718 Smyth Road"
    city "Manchester"
    state "NH"
    country "USA"
    site_station_number "500"
  end

  factory :orig_manchester_va, class: Site do
    name "Manchester VA Medical Center"
    address "718 Smyth Road"
    city "Manchester"
    state "NH"
    country "USA"
    site_station_number "608"
  end
end