# == Schema Information
#
# Table name: examination_schedules
#
#  id                   :integer          not null, primary key
#  examination_id       :integer
#  reschedule_reason    :text
#  active               :boolean
#  exam_date_time       :datetime
#  created_at           :datetime         not null
#  updated_at           :datetime         not null
#  cancel_code          :string
#  cancel_reason        :string
#  appt_address_1       :string
#  appt_address_2       :string
#  appt_address_city    :string
#  appt_address_state   :string
#  appt_address_zipcode :string
#  book_notes           :text
#  site_station_number  :string
#  cancel_remarks       :text
#

FactoryBot.define do
  factory :examination_schedule_active, class: ExaminationSchedule do
    active true
  end

  factory :examination_schedule_not_active, class: ExaminationSchedule do
    active false
  end
end
