require 'rails_helper'

RSpec.describe ReferralDocumentsController, :type => :controller do
  before do
    @test_vha_user = create(:vha_user)
    sign_in @test_vha_user
  end

  describe 'POST ajax delete referral document' do
    it "returns http success", cpp: true do
      deleted_msg = 'This is the deleted reason...'
      referral_document = create(:referral_document)
      expect(referral_document.deleted_reason).to be_nil

      xhr('post', 'ajax_delete_referral_doc', referral_doc_id: referral_document.id, reason: deleted_msg, format: :json)
      parsed_body = JSON.parse(response.body)
      expect(parsed_body['success']).to be_truthy
      referral_document.reload
      expect(referral_document.deleted_reason).to eq deleted_msg
      expect(referral_document.deleted_at).not_to be_nil
    end
  end

end
