#!/usr/bin/env ruby
require 'csv'
require 'fileutils'
require 'rails/all'

class Report
  def initialize(params)
    @current_script   = params[:current_script]
    @environment      = params[:environment]
    @my_class_name    = self.class.name
    @pid              = params[:pid]
    @report_base_name = params[:report_base_name]
    @target_folder    = params[:target_folder]
    @server_name      = params[:server_name]
    @deploy_type      = params[:deploy_type]
  end

  def run
    Rails.logger.debug("#{@current_script} #{@my_class_name}\##{__method__} " \
                       "start")
    rc = generate_report(@file_name = file_name(@target_folder,
                                                @report_base_name))
    msg = rc == true ? 'successfully' : 'with errors'
    Rails.logger.debug("#{@current_script} #{@my_class_name}\##{__method__} "\
                       "ending #{msg}")
    rc
  end

  private
    def file_name(folder, name)
      ts = Time.now.strftime('%Y%m%d_%H%M%S')
      File.join(folder, Rails.env + '_' + name + '_' + ts)
    end

    def generate_report(fq_name)
      # Generate a csv as the report
      file_name = "#{fq_name}.csv"
      path = File.dirname(file_name)

      Rails.logger.debug("#{@current_script} #{@my_class_name}\##{__method__} " \
                         "server name: #{@server_name} report file name: "\
                         "#{file_name}")

      FileUtils.mkdir_p(path) unless File.directory?(path)

      attributes = 'authorization_state last_name first_name email ' \
                    'last_sign_in_at last_sign_in_ip application roles ' \
                    'is_under_review provider created_at updated_at ' \
                    'deploy_type'.split(' ')

      path = File.dirname(file_name)

      begin
        CSV.open(file_name, 'wb') do |csv|
          csv << attributes

          users = User.all.order("authorization_state ASC, "\
                                 "last_name ASC, first_name ASC")
          Rails.logger.debug("#{@current_script} #{@my_class_name}\#" \
                             "#{__method__} #{users.count} users to process")

          users.each do |user|
            key = 'authorization_state'.to_sym
            user[key] = user[key] == 'authorized' ? 'Active' : 'Not Active'

            row = user.attributes.values_at(*attributes)

            i = attributes.index { |x| x.include?('deploy_type') }
            row[i] = @deploy_type

            i = attributes.index { |x| x.include?('application') }
            row[i] = user.is_cui_user? ? 'CUI' : 'CPP'

            csv << row
          end
        end

      rescue StandardError=>e
        Rails.logger.debug("#{@current_script} #{@my_class_name}\##{__method__}" \
                           "server name: #{@server_name} #{users.count} " \
                           "Error: #{e}")
        puts "Error: #{e}"
        false
      else
        true
      end
  end
end
