# common/lib/environments_list.rb
def environments_list(root)
  arr = []

  search_path = File.join(root, %w[config environments *.rb])
  file_names = Dir[search_path]                   # Array of file names
  file_names.each do |file_name|
    fn = File.basename(file_name, '.*' )          # Remove ext if any
    arr << Hash[fn[0,4], fn]
    arr << Hash['tst', fn] if fn == 'test'
    arr << Hash['dev', fn] if fn == 'development'
  end

  arr
end
