#!/usr/bin/env rails runner lib/tools/form_filler_outer.rb

require 'byebug'
require 'ffaker'
require 'fml_forms'
require 'rspec'
require 'xml'

class Node
  attr_reader :conditions, :field

  def initialize(field)
    @field = field
    @conditions = Hash.new{|h,k| h[k] = []}
  end
end

# return the requiredIf validations for a given field
def requiredif(field)
  if field.validations
    field.validations.select {|x| x.has_key? "requiredIf"}.map {|x| x["requiredIf"]}
  else
    []
  end
end

def trees(form)
  trees = []
  index = {}

  # on the first pass, just create a node for each field and add it to the
  # index
  form.fields.each do |name, field|
    node = Node.new(field)
    index[name] = node
  end

  # do another pass and capture all the requirements
  form.fields.each do |name, field|
    node = index[name]
    if requiredif(field).empty?
      trees << node
    else
      requiredif(field).each do |requirement|
        # TODO: we're ignoring textEquals
        if requirement.starts_with? "!"
          # strip the !
          requirement = requirement[1..-1]
          index[requirement].conditions[false] << index[name]
        else
          index[requirement].conditions[true] << index[name]
        end
      end
    end
  end

  [trees, index]
end

def choose(arr)
  arr.sort_by { SecureRandom.random_number }[0]
end

def fill(field)
  case field.type
  when "yes_no"
    field.value = choose([true, false])
  when "string"
    field.value = FFaker::HealthcareIpsum.sentence
  when "text"
    field.value = FFaker::HealthcareIpsum.paragraph
  when "select"
    field.value = choose(field.options)["value"]
  when "number"
    field.value = SecureRandom.random_number * 100
  end
  #TODO: date, what else?
end

def fillnode(node)
  if node.field.required
    fill(node.field)
  else
    if SecureRandom.random_number > 0.25
      fill(node.field)
    end
  end

  nextnodes = node.conditions[node.field.value]
  nextnodes.each do |node|
    fillnode(node)
  end
end

def filltrees(trees)
  trees.each { |t| fillnode(t) }
end

SCHEMA = XML::Schema.document(
  XML::Document.file(
    Rails.root.join("app/xsd/ExamResponse/exchange/ExamResponse-2.0.xsd").to_s
  )
)

def validate(xml)
  XML::Document.string(xml).validate_schema(SCHEMA)
end

all_specs = EvaluationSpec.all
cardio_specs = EvaluationSpec.where(body_system: "Cardiovascular")
user = User.first
claim = Claim.first
1.times do |i|
  spec = choose(cardio_specs)
  puts "filling evaluation #{spec.id}: #{spec.title}"
  form = FML::Form.new(spec.spec)
  trees, index = trees(form)
  filltrees(trees)

  e = Evaluation.new(evaluation_spec: spec, doc: form.to_json, user: user, claim: claim)
  begin
    xml = e.to_xml(false)
  # If we don't yet have a presenter for the body system of the evaluation, it
  # raises a LoadError
  rescue LoadError, NameError
    puts "LoadError, continuing"
    next
  end

  File.write("/tmp/x.xml", xml)

  begin
    validate(xml)
  rescue LibXML::XML::Error
    File.open("/tmp/spec.json", 'w') { |f| f.write(form.to_json) }
    File.open("/tmp/spec.xml", 'w') { |f| f.write(e.to_xml(false)) }
    raise
  end
  #RSpec.describe Evaluation do
  #  it "should validate" do
  #    allow(e).to receive(:to_pdf).and_return "don't waste time generating the PDF"
  #  end
  #end
end
