module AddUsersHelper

  def sanitize(value)
    v = ActionController::Base.helpers.strip_links(value)
    ActionController::Base.helpers.sanitize(v)
  end

  def get_app_long_name_func(user)
    app = user.is_cpp_user?
    case app
      when true
        "Community Provider Portal"
      when false
        "Clinician User Interface"
    end
  end

  def welcome_email_msg_func(password_field)
    return <<-END_EMAIL_MSG
      You are receiving this email because your account for the Clinician User Interface is now ready!

      Please login at: #{LOGIN_URL}

      Login: your email address
      Password: #{password_field}
    END_EMAIL_MSG
  end

  def statistics_email_msg_func(input_file, added,failed,skipped)
    return <<-END_EMAIL_MSG
      Statistics for add_users script run using #{input_file}

      Number of users created: #{added}
      Number of users failed:  #{failed}
      Number of users skipped: #{skipped}
    END_EMAIL_MSG
  end

  #TODO: Nathan Wright refactor of Roles Mgmt should render the data structure below
  # redundant and instead results in a call to include his module in this one
  ROLES = {
              supervisor:           "Supervisor",
              examiner:             "Examiner",
              medical_assistant:    "Medical Assistant" ,
              administrator:        "Administrator",
              quality_assurance:    "Quality Assurance",
              supervisory_clinician:"Supervisory Clinician",
              clinician:            "Clinician",
              triage:               "Triage",
              scheduling:           "Scheduling",
              site_user:            "Site User",
              vha_cc:               "VHA Coordinator",
              non_vha:              "Community Provider"
  }.freeze
  ROLES_SET = ROLES.to_set.freeze



end
