# lib/tasks/erd/cpp.rake

namespace :erd do

  namespace :cpp do

    # designate the output file for the doc directory; extract filename
    # components to use on the erd command line.
    def extract_file_components(a_string)
      out_path = Rails.root + 'doc' + a_string    # putting all output files into the doc directory
      filetype = out_path.extname.to_s[1,99]      # ignore the first character because its always '.'
      filename = out_path.to_s.gsub(".#{filetype}",'')
      return filename, filetype
    end

    BASE_ERD_COMMAND = "cd #{Rails.root} && bundle exec erd --orientation=vertical --cluster --prepend_primary=true --sort=true " # NOTE: must end with a space

    task all: [:top, :referral, :consultation, :provider]

    desc "Generate CPP feature set top-level ERD"
    task :top do
      out_filename        = 'cpp_top_level_erd.pdf'
      filename, filetype  = extract_file_components out_filename

      system BASE_ERD_COMMAND + "--title='Top-level CPP Data Model' --direct --only='UserPreference,User,Visn,Facility,Provider,ProvidersUser,Veteran,Referral,Consultation' --filename=#{filename} --filetype=#{filetype}"
    end

    desc "Generate CPP feature set ERD for Referral Model"
    task :referral do
      out_filename        = 'cpp_referral_erd.pdf'
      filename, filetype  = extract_file_components out_filename

      system BASE_ERD_COMMAND + "--title='CPP Referral Data Model' --only_recursion_depth=1 --only='Referral,' --filename=#{filename} --filetype=#{filetype}"
    end

    desc "Generate CPP feature set ERD for Consultation Model"
    task :consultation do
      out_filename        = 'cpp_consultation_erd.pdf'
      filename, filetype  = extract_file_components out_filename

      system BASE_ERD_COMMAND + "--title='CPP Consultation Data Model' --only_recursion_depth=1 --only='Consultation,' --filename=#{filename} --filetype=#{filetype}"
    end

    desc "Generate CPP feature set ERD for Provider Model"
    task :provider do
      out_filename        = 'cpp_provider_erd.pdf'
      filename, filetype  = extract_file_components out_filename

      system BASE_ERD_COMMAND + "--title='CPP Provider Data Model' --only_recursion_depth=1 --only='Provider,' --filename=#{filename} --filetype=#{filetype}"
    end

  end # namespace :cpp do

  desc "Generate all ERDs for CPP feature set"
  task :cpp do
    Rake::Task["erd:cpp:all"].invoke
  end

end # namespace :erd do