require "#{Rails.root}/lib/tasks/helpers/version_helper"
include VersionHelper

namespace :eval_specs do

  desc 'Assign missing spec_ids to EvalautionSpecs'
  task assign_missing_specids: :environment do
    EvaluationSpec.all.each do |eval_spec|
      if eval_spec.spec.blank?
        eval_spec.destroy
      elsif eval_spec.spec_id.blank? 
        spec = YAML.load(eval_spec.spec);
        spec["form"]["id"] = SecureRandom.hex(20)
        spec["form"]["version"] = increment_patch_number(spec["form"]["version"])
        eval_spec.update_attributes(spec: spec.to_yaml)
      end
    end

  end
end
