class SiteClinicsLoader

  def load!(site_station_number, vista_session)
    @site = Site.find_by_site_station_number(site_station_number)
    return unless ready_to_be_loaded?

    update_loading_state(:loading)
    reset_clinics
    new_clinics = fetch_clinics(vista_session)
    update_clinics(new_clinics)
    update_loading_state(:loaded)

  rescue Exception => e
    update_loading_state(:initial)
    reset_clinics
    raise e
  end

  private

  def update_loading_state(state)
    @site.update!(clinics_loaded_state: state)
  end

  def reset_clinics
    @site.clinics = []
  end

  def fetch_clinics(vista_session)
    site_station_number = @site.site_station_number
    clinic_list = VIA_API::SchedulingService.get_all_clinics(site_station_number, vista_session)
  end

  def update_clinics(clinic_list)
    clinic_list.each do |via_clinic_model|
      @site.clinics << Clinic.create!(clinic_identifier: via_clinic_model.id, name: via_clinic_model.name, content: via_clinic_model)
    end
  end

  def ready_to_be_loaded?
    !@site.loading?
  end

end
