class ExaminationAssignClinician
  FLASH_MESSAGE = "Examination has been successfully updated."

  def initialize(examination_history_klass=ExaminationHistory, exam_management_mailer_klass=ExamManagementMailer, user_klass=User)
    @examination_history_klass = examination_history_klass
    @exam_management_mailer_klass = exam_management_mailer_klass
    @user_klass = user_klass
  end

  def run!(examination, clinician, current_user)
    @examination = examination
    @clinician = clinician
    @current_user = current_user

    return if clinician_is_unchanged?

    create_history_log!(create_history_notes)
    update_examination_clinician!
    deliver_mailer!

    FLASH_MESSAGE
  end

  private

  def clinician_is_unchanged?
    # examination.clinician is actually a reference to the clinician's id
    @examination.clinician == @clinician.id
  end

  def create_history_notes
    if examination_has_clinician?
      previous_clinician = @user_klass.find_by_id(@examination.clinician)
      "#{@current_user.name} changed the clinician from #{previous_clinician.name} to #{@clinician.name}."
    else
      "#{@current_user.name} assigned #{@clinician.name} as the clinician."
    end
  end

  def examination_has_clinician?
    @examination.clinician
  end

  def create_history_log!(notes)
    examination_history = @examination_history_klass.new(examination_id: @examination.id, notes: notes)
    examination_history.save
  end

  def update_examination_clinician!
    @examination.assign_a_clinician(@clinician.id) #cs 2016-09-13
    @examination.save
  end

  def deliver_mailer!
    @exam_management_mailer_klass.examination_clinician_assigned(@clinician).deliver_now
  end


end
