module ActiveRecordExtension
  extend ActiveSupport::Concern

  # add your class methods here
  module ClassMethods
    # Creates accessor methods (generic getter and setter) on content hash
    # for all fields passed in.  Does not work if 'content' field does not
    # exist as type json, and assumes that content hash does not have
    # symbolized keys.
    def autowire_content_fields(*fields)
      fields = [fields] unless fields.is_a?(Array)
      instance_eval do
        fields.each do |field|
          define_method(field.to_s) do
            self.content ||= {}
            self.content[field.to_s]
          end
          define_method("#{field}=") do |val|
            self.content ||= {}
            self.content[field.to_s] = val
          end
        end
      end
    end
  end
end

# include the extension
ActiveRecord::Base.send(:include, ActiveRecordExtension)
