# Branch Strategy

There are three teams working in the project's repository.  Each team has ownership of different branches.  Eacg team use a similar strategy in managing its branches.  The intent of this document is to acquaint new developers on the project with how each team works with regard to its the branching strategy for this repository.

The three teams are:

  * CPP - Community Provider Portal - CSRA.com - The Enterprise Veterans Self-Service (EVSS) contract
  * CUI - Clianians User Interface - VetsEZ
  * SMS - Systems Made Simple - owned by Lockheed Martin - the operations and maintenance contract

## Configuration Management

The VetsEZ company has the responsibility to the customer for overall configuration management of the project.  The current configuration manager (CM) is Regina Frost.

The project's repositories are managed in an enterprise instance of bitbucket.com software configuration management system maintained by VetsEZ.

The repository URL is https://bitbucket.vetsez.net/projects/CUI/repos/cui/browse


### Branch Structure

    -── master
        ├── integration
        │   ├── cpp_integration
        │   │   └── cpp_develop
        │   │       └── PP-xxxxx
        │   ├── cui_integration
        │   │   ├── CUI-xxxxx
        │   │   └── sms_integration
        │   │       └── DOM-xxxxx
        │   ├── fbe_content
        │   └── fbe_test
        │       └── CUI-xxxxx
        └── release-x.x.x
            └── release-x.x.x-int
                ├── CUI-xxxxx
                ├── DOM-xxxxx
                └── PP-xxxxx

The CM owns the master, integration and release branches.  No one other than the CM is allowed to make any changes to these branches.

The branches prefixed with 'cpp_' and 'PP-' are owned by the CPP team.

The branches prefixed with 'cui' and 'fbe' are owned by the CUI team.

The branches prefixed with 'sms' and 'dom' are owned by the SMS team.

Content changes flow from the bottom up through the various branches.

At the end of a sprint release cycle the branches a base-lined from the top down.

The following sections discuss each team's process.


## CPP - Community Provider Portal

The CPP team's branch structure starts with cpp_integration.  cpp_integration is CPP team's "master" branch.  It is owned by the CPP software development lead.  The current lead is Dewayne VanHoozer.

Content changes to the cpp_integration branch flow into the CM controlled integration branch via a pull request at the end of each sprint.

All changes to CPP branches start with a JIRA-managed ticket.  The tickets are number in the form 'PP-####' where '####' is the ticket number.  The 'PP' is the "Provider Portal" project definition within the CSRA/EVSS JIRA system.


### Develop Branch

The CPP team's develop branch is named cpp_develop.  It is from this branch that all task branches are derived using the JIRA ticket as the name of the task's branch.

RECAP: A task branch is created from the cpp_develop branch.  At the end of the task a pull request (PR) is generated to fold the task branch back into the cpp_develop branch.

For example, this is a typical process for a developer who is assigned JIRA task PP-409.

    # Start a new task branch with the latest cpp_develop content
    git checkout cpp_develop
    git pull
    git checkout -b PP-409

    # Do good work
    rake cpp:test
    # All Tests PASS!
    git commit -m 'PP-409: fixed stuff'

    # Integration the task branch with other developer's merged tasks
    git checkout cpp_develop
    git pull
    git checkout PP-409
    git rebase cpp_develop

    # Test to ensure no problems caused by integration with other tasks
    rake cpp:test
    git commit -m 'PP-409: fixed more stuff'
    git push origin PP-409

    # Create a pull request (PR) with the entire CPP team as the default reviewers
    # Add members from other teams when there is a potential for impact on their tasks

Note how the commit messages in the above sequence had the JIRA ticket Number (aka branch name) in the message.  This can be done automatically for any developer if they have installed the project's standard git hooks.  See the file doc/new_developer_startup.md for a discussion on how to install the hooks.  With the git hooks in place, git will automatically perpend the name of the branch to each commit message.

Having the JIRA ticket number (For CPP is also the branch name) as part of each commit message is an important part of configuration management in that it provides detailed traceability for every change back to a specific requirement.


### Pull Request task branch targets the cpp_develop branch

When a task branch is ready, the developer generates a pull request (PR) for the task branch that targets the cpp_develop branch.  All pull requests must have at least two approvals before it can be merged.  This is true for both the cpp_develop and the cpp_integration branches.

All CPP software developers are designated as default reviewers of every PR.  These reviewers will add comments to the code and approved or reject these new changes.  When the code is approved, the branch is merged into the cpp_develop by the software development lead.

Any task branch that may have an impact on the other teams working in this repository should add appropriate members of those other teams as reviewers for the PR in addition to the default CPP reviewer.  Typically added are the software development leads from the other teams as well as the CM.


### Pull Request at end of the Sprint

At the end of each sprint, the cpp_develop branch is integrated into the cpp_integration branch using a PR targeting the cpp_integration branch.  This PR is typically short-lived.  Its purpose is to show all the new changes that the CPP team is pushing to the overall application.  Generally the PR is merged by the CPP software development lead without the normal two approver condition.


### Final Step for CPP changes to be integrated with the other teams changes

A pull request for the cpp_integration branch targeting the integration branch is the final step if a sprint release for the CPP team.  The reviewers for this PR should included app CPP developers, the software development leads for the other teams  and their senior developers and the configuration manager.  This is the CPP team's last chance to catch any problems before the CM merges the CPP changes into the overall application.


#### Conflict Resolution

The CPP Software development lead is responsible for resolving any conflicts between changes made by the CPP team and those made by the other teams.  This is done by ensuring that the cpp_integration branch is kept updated with the integration branch.  The CPP lead may reach out to other CPP developers to help resolve conflicts as they arise.

This process of integrating the cpp_integration branch with the other teams contributions has historically taken about half a sprint.  While this multi-team integration process is proceeding, the CPP team begins work on the next sprint's JIRA tickets using the cpp_develop branch as a base.

When the CM closes the integration process, the CPP software lead merges the cpp_integration branch into the cpp_develop branch as the new basis from which new changes are built.

The CPP lead will notify all CPP developers to re baseline their existing working directories to the new content in the cpp_develop branch.

Note that this process allows the CPP team to continue sprint development without impacting the multi-team integration process; or, more precisely for the multi-team integration process not to impact the progress of the CPP team's new sprint.


### Working Directories

Developer's are free to manage their own development environments to suit their own tastes and development style.  Some use an integrated development environment (IDE) like [RubyMine](https://www.jetbrains.com/ruby/) while others may use a line editor, spit, gum and bailing wire; but we all have the same basic requirement for managing our working directories.

Here is one way that seems to work well.

Have two working directories:  cpp_develop  and  cpp_feature.

    git clone "the repo to" cpp_develop
    cd cpp_develop
    git checkout cpp_develop
    cp hooks_for_git/* .git/hooks
    cd ..
    cp -R cpp_develop cpp_feature

The cpp_develop directory is your base directory.  The cpp_feature directory is the directory where you create your task branches.  Its also the place where you can checkout other branches during pull request reviews.

If you ever get your cpp_feature directory screwed up beyond easy repair, you can always delete it with its unpushed changes and recreate it from the cpp_develop directory.


## CUI - Clinician Users Interface

TODO: Add instructions for new CUI developers regarding the handling of branches


## SMS - Systems Made Simple (Operations and Maintenance Contract)

TODO: Add instructions for new O&M developers regarding the handling of branches
