class ChangeBoilerplateMessageAndDbqInformationAttributes < ActiveRecord::Migration
  def change
  	rename_column :boilerplate_messages, :boilerplate_message_name, :name
  	rename_column :boilerplate_messages, :boilerplate_message_content, :content
  	add_column :boilerplate_messages, :created_at, :datetime, null: false
  	add_column :boilerplate_messages, :updated_at, :datetime, null: false

  	rename_column :dbq_informations, :dbq_identifier, :identifier
  	rename_column :dbq_informations, :dbq_title, :title
  	add_column :dbq_informations, :created_at, :datetime, null: false
  	add_column :dbq_informations, :updated_at, :datetime, null: false

  	drop_table :boilerplate_messages_dbq_informations
  	drop_table :contentions_dbq_informations

    create_table :boilerplate_messages_dbq_informations do |t|
      t.integer :boilerplate_message_id, null: false
      t.integer :dbq_information_id, null: false
      t.integer :position
    end

    #BoilerplateMessagesDbqInformation.all.each { |in| in.update_attribute(:position, in.id)}

    add_index :boilerplate_messages_dbq_informations,
    	[:boilerplate_message_id, :dbq_information_id], name: :idx_boilerplate_message_dbq_info

    create_table :contentions_dbq_informations do |t|
    	t.integer :contention_id, null: false
      t.integer :dbq_information_id, null: false
      t.integer :position
    end

    #ContentionDBQInformation.all.each { |in| in.update_attribute(:position, in.id)}

    add_index :contentions_dbq_informations,
    	[:contention_id, :dbq_information_id], name: :idx_contention_dbq_info

    create_table :diagnoses_dbq_informations do |t|
      t.integer :diagnosis_id, null: false
      t.integer :dbq_information_id, null: false
      t.integer :position
    end

    add_index :diagnoses_dbq_informations,
      [:diagnosis_id, :dbq_information_id], name: :idx_diagnosis_dbq_info

    create_table :symptoms_dbq_informations do |t|
      t.integer :symptom_id, null: false
      t.integer :dbq_information_id, null: false
      t.integer :position
    end

    add_index :symptoms_dbq_informations,
      [:symptom_id, :dbq_information_id], name: :idx_symptom_dbq_info

    create_table :general_questions_dbq_informations do |t|
      t.integer :general_question_id, null: false
      t.integer :dbq_information_id, null: false
      t.integer :position
    end

    add_index :general_questions_dbq_informations,
      [:general_question_id, :dbq_information_id], name: :idx_general_question_dbq_info
  end
end
