#
# Run this file (from within the web_server container)to initiate the test data for the first 9 DBQs by:
#   ruby r db/dbq_test_data_init.rb
#
#BoilerplateMessage

#General DBQ Boilerplate Message
general_dbq_boilerplate_message=
    BoilerplateMessage.create!( :name=>"General DBQ Boilerplate",
                                :content=>"This is a boilerplate message that should be contained for every requested DBQ")

#Mental Disorder:  "DBQ PSYCH Mental Disorders"
mental_disorder_boilerplate_message =
    BoilerplateMessage.create!( :name=>"DBQ PSYCH Mental Disorders Boilerplate",
                                :content=>"This is a boilerplate message for DBQ PSYCH Mental Disorders")

#Initial PTSD:  "DBQ PSYCH PTSD Initial"
initial_ptsd_boilerplate_message =
        BoilerplateMessage.create!( :name=>"DBQ PSYCH PTSD Initial Boilerplate",
                                    :content=>"This is a boilerplate message for DBQ PSYCH PTSD Initial")

#PTSD Review:  "DBQ PSYCH PTSD Review"
ptsd_review_boilerplate_message =
        BoilerplateMessage.create!( :name=>"DBQ PSYCH PTSD Review Boilerplate",
                                    :content=>"This is a boilerplate message for DBQ PSYCH PTSD Review")

#Hearing Loss and Tinnitus:  "DBQ AUDIO Hearing Loss and Tinnitus"
hearing_loss_boilerplate_message =
        BoilerplateMessage.create!( :name=>"DBQ AUDIO Hearing Loss and Tinnitus Boilerplate",
                                    :content=>"This is a boilerplate message for DBQ AUDIO Hearing Loss and Tinnitus")

#Knee:  "DBQ MUSC Knee and Lower Leg"
knee_boilerplate_message =
        BoilerplateMessage.create!( :name=>"DBQ MUSC Knee and Lower Leg Boilerplate",
                                    :content=>"This is a boilerplate message for DBQ MUSC Knee and Lower Leg")

#Artery and Vein: "DBQ CARDIO Arteries & Veins (vascular)"
artery_and_vein_boilerplate_message =
        BoilerplateMessage.create!( :name=>"DBQ CARDIO Arteries & Veins (vascular) Boilerplate",
                                    :content=>"This is a boilerplate message for DBQ CARDIO Arteries & Veins (vascular)")

#Back - T(horacic) Spine: "DBQ MUSC Back (thoracolumbar spine)"
back_boilerplate_message =
        BoilerplateMessage.create!( :name=>"DBQ MUSC Back (thoracolumbar spine) Boilerplate",
                                    :content=>"This is a boilerplate message for DBQ MUSC Back (thoracolumbar spine)")

#Neck - C(ervical) Spine:  "DBQ MUSC Neck (cervical spine)"
neck_boilerplate_message =
        BoilerplateMessage.create!( :name=>"DBQ MUSC Neck (cervical spine) Boilerplate",
                                    :content=>"This is a boilerplate message for DBQ MUSC Neck (cervical spine)")

#Foot: "DBQ MUSC Foot Conditions Including Flatfoot (Pes Planus)"
foot_boilerplate_message =
        BoilerplateMessage.create!( :name=>"DBQ MUSC Foot Conditions Including Flatfoot (Pes Planus) Boilerplate",
                                    :content=>"This is a boilerplate message for DBQ MUSC Foot Conditions Including Flatfoot (Pes Planus)")

#Gen Med DBQ : SHA
gen_med_sha_boilerplate_message =
        BoilerplateMessage.create!( :name=>"DBQ General Medical - Separation Health Assessment Disability Benefits Questionnaire",
                                    :content=>"DBQ General Medical - Separation Health Assessment Disability Benefits Questionnaire")

#DBQ General Medical Separation Health Assessment with Gulf War
gen_med_gulf_war_boilerplate_message =
        BoilerplateMessage.create!( :name=>"DBQ General Medical Separation Health Assessment with Gulf War",
                                    :content=>"DBQ General Medical Separation Health Assessment with Gulf War")


#
#
#DbqInformation

#Mental Disorder:  "DBQ PSYCH Mental Disorders"
mental_disorder_dbq_information =
    DbqInformation.create!( :identifier => "DBQ PSYCH Mental Disorders",
                            :title => "DBQ PSYCH Mental Disorders Title" )

#Initial PTSD:  "DBQ PSYCH PTSD Initial"
intial_ptsd_dbq_information =
    DbqInformation.create!( :identifier => "DBQ PSYCH PTSD Initial",
                            :title => "DBQ PSYCH PTSD Initial Title" )

#PTSD Review:  "DBQ PSYCH PTSD Review"
ptsd_review_dbq_information =
    DbqInformation.create!( :identifier => "DBQ PSYCH PTSD Review",
                            :title => "DBQ PSYCH PTSD Review Title" )

#Hearing Loss and Tinnitus:  "DBQ AUDIO Hearing Loss and Tinnitus"
hearing_loss_dbq_information =
    DbqInformation.create!( :identifier => "DBQ AUDIO Hearing Loss and Tinnitus",
                            :title => "DBQ AUDIO Hearing Loss and Tinnitus Title" )

#Knee:  "DBQ MUSC Knee and Lower Leg"
knee_dbq_information =
    DbqInformation.create!( :identifier => "DBQ MUSC Knee and Lower Leg",
                            :title => "DBQ MUSC Knee and Lower Leg Title" )

#Artery and Vein: "DBQ CARDIO Arteries & Veins (vascular)"
artery_and_vein_dbq_information =
    DbqInformation.create!( :identifier => "DBQ CARDIO Arteries & Veins (vascular)",
                            :title => "DBQ CARDIO Arteries & Veins (vascular) Title" )

#Back - T(horacic) Spine: "DBQ MUSC Back (thoracolumbar spine)"
back_dbq_information =
    DbqInformation.create!( :identifier => "DBQ MUSC Back (thoracolumbar spine)",
                            :title => "DBQ MUSC Back (thoracolumbar spine) Title" )

#Neck - C(ervical) Spine:  "DBQ MUSC Neck (cervical spine)"
neck_dbq_information =
    DbqInformation.create!( :identifier => "DBQ MUSC Neck (cervical spine",
                            :title => "DBQ MUSC Neck (cervical spine Title" )

#Foot: "DBQ MUSC Foot Conditions Including Flatfoot (Pes Planus)"
foot_dbq_information =
    DbqInformation.create!( :identifier => "DBQ MUSC Foot Conditions Including Flatfoot (Pes Planus)",
                            :title => "DBQ MUSC Foot Conditions Including Flatfoot (Pes Planus) Title" )

#Gen Med DBQ SHA
gen_med_sha_dbq_information =
    DbqInformation.create!( :identifier => "DBQ General Medical - Separation Health Assessment Disability Benefits Questionnaire",
                            :title => "DBQ General Medical - Separation Health Assessment Disability Benefits Questionnaire" )

#Gen Med DBQ Gulf War
gen_med_gulf_war_dbq_information =
    DbqInformation.create!( :identifier => "DBQ General Medical Separation Health Assessment with Gulf War",
                            :title => "DBQ General Medical Separation Health Assessment with Gulf War" )

#
#
# Associations

mental_disorder_dbq_information.creates_a_unique_boilerplate_message_association_with(general_dbq_boilerplate_message)
mental_disorder_dbq_information.creates_a_unique_boilerplate_message_association_with(mental_disorder_boilerplate_message)

intial_ptsd_dbq_information.creates_a_unique_boilerplate_message_association_with(general_dbq_boilerplate_message)
intial_ptsd_dbq_information.creates_a_unique_boilerplate_message_association_with(initial_ptsd_boilerplate_message)

ptsd_review_dbq_information.creates_a_unique_boilerplate_message_association_with(general_dbq_boilerplate_message)
ptsd_review_dbq_information.creates_a_unique_boilerplate_message_association_with(ptsd_review_boilerplate_message)

hearing_loss_dbq_information.creates_a_unique_boilerplate_message_association_with(general_dbq_boilerplate_message)
hearing_loss_dbq_information.creates_a_unique_boilerplate_message_association_with(hearing_loss_boilerplate_message)

knee_dbq_information.creates_a_unique_boilerplate_message_association_with(general_dbq_boilerplate_message)
knee_dbq_information.creates_a_unique_boilerplate_message_association_with(knee_boilerplate_message)

artery_and_vein_dbq_information.creates_a_unique_boilerplate_message_association_with(general_dbq_boilerplate_message)
artery_and_vein_dbq_information.creates_a_unique_boilerplate_message_association_with(artery_and_vein_boilerplate_message)

back_dbq_information.creates_a_unique_boilerplate_message_association_with(general_dbq_boilerplate_message)
back_dbq_information.creates_a_unique_boilerplate_message_association_with(back_boilerplate_message)

neck_dbq_information.creates_a_unique_boilerplate_message_association_with(general_dbq_boilerplate_message)
neck_dbq_information.creates_a_unique_boilerplate_message_association_with(neck_boilerplate_message)

foot_dbq_information.creates_a_unique_boilerplate_message_association_with(general_dbq_boilerplate_message)
foot_dbq_information.creates_a_unique_boilerplate_message_association_with(foot_boilerplate_message)

gen_med_sha_dbq_information.creates_a_unique_boilerplate_message_association_with(general_dbq_boilerplate_message)
gen_med_sha_dbq_information.creates_a_unique_boilerplate_message_association_with(gen_med_sha_boilerplate_message)

gen_med_gulf_war_dbq_information.creates_a_unique_boilerplate_message_association_with(general_dbq_boilerplate_message)
gen_med_gulf_war_dbq_information.creates_a_unique_boilerplate_message_association_with(gen_med_gulf_war_boilerplate_message)
