#!/usr/bin/env puma
# config/puma.rb

# NOTE: This file is loaded before rails is started ...

module DeapCuiCppPumaUtility   # how's that for name-spacing?
  def self.extend_relative_paths_in_puma_bind(puma_bind_string, prefix_path)
    unless Pathname == prefix_path.class  &&  prefix_path.exist?  &&  prefix_path.absolute?
      raise "Invalid prefix_path:  #{prefix_path}"
    end
    prefix_string = prefix_path.to_s
    prefix_string += '/' unless prefix_string.end_with?('/')
    final_string = puma_bind_string.dup
    %w( key= cert= ca= ).each do |token|
      final_string.gsub!(token, "#{token}#{prefix_string}") if final_string.include?(token)
    end
    final_string
  end
end

require 'pathname'
require 'dotenv'


me        = Pathname.new(__FILE__).realpath
my_dir    = me.parent
root      = my_dir.parent
tmp_dir   = root    + 'tmp'
log_dir   = root    + 'log'
pids_dir  = tmp_dir + 'pids'


ENV['RACK_ENV']     = 'development'   unless ENV.has_key?('RACK_ENV')
ENV['RAILS_ENV']    = 'development'   unless ENV.has_key?('RAILS_ENV')
ENV['DEPLOY_TYPE']  = 'localhost'     unless ENV.has_key?('DEPLOY_TYPE')


# SMELL: Bug? in Rails v4.2.3 Rails.root and RAILS_ROOT are not defined at this point
#        in the startup process.
RAILS_ROOT = Pathname.new(__FILE__).parent.parent.realpath unless defined?(RAILS_ROOT)

# Load the .env* files in the opposite order as bin/setup_environment.
# dotenv sets and maintains the value of a variable the FIRST time it is assigned.  This allows the
# use of existing shell values to over-ride any value specified in a .env* file.
# NOTE: ignoring the railtie
# SMELL: This sequence MUST be the same as used by config/application.rb

Dotenv.load(  # If a file does not exist, dotenv will ignore it in the load() method
              RAILS_ROOT + ".env.#{ENV['DEPLOY_TYPE']}.local",
              RAILS_ROOT + ".env.#{ENV['RAILS_ENV']}.local",
              RAILS_ROOT + ".env.local",
              RAILS_ROOT + ".env.#{ENV['DEPLOY_TYPE']}",
              RAILS_ROOT + ".env.#{ENV['RAILS_ENV']}",
              RAILS_ROOT + ".env"
)


$puma_conf_pass = $puma_conf_pass.nil? ? 1 : $puma_conf_pass + 1


# The directory to operate out of.
#
# The default is the current directory.
#
# directory '/u/apps/lolcat'

directory RAILS_ROOT


# Load "path" as a rackup file.
#
# The default is "config.ru".
#
# rackup '/u/apps/lolcat/config.ru'

rackup RAILS_ROOT + 'config.ru'

# Set the environment in which the rack's app will run. The value must be a string.
#
# The default is "development".
#
# environment 'production'

environment  ENV['RAILS_ENV']


# Daemonize the server into the background. Highly suggest that
# this be combined with "pidfile" and "stdout_redirect".
#
# The default is "false".
#
# daemonize
# daemonize false

daemonize defined?(PUMA_DAEMONIZE) ? PUMA_DAEMONIZE :
          (
            (
              !ENV['PUMA_DAEMONIZE'].nil? && %w[true yes].include?(ENV['PUMA_DAEMONIZE'].downcase)
            ) ? true : false
          )


# Store the pid of the server in the file at "path".
#
# pidfile '/u/apps/lolcat/tmp/pids/puma.pid'

pidfile pids_dir + 'puma.pid'


# Use "path" as the file to store the server info state. This is
# used by "pumactl" to query and control the server.
#
# state_path '/u/apps/lolcat/tmp/pids/puma.state'

state_path pids_dir + 'puma.state'


# Redirect STDOUT and STDERR to files specified. The 3rd parameter
# ("append") specifies whether the output is appended, the default is
# "false".
#
# stdout_redirect '/u/apps/lolcat/log/stdout', '/u/apps/lolcat/log/stderr'
# stdout_redirect '/u/apps/lolcat/log/stdout', '/u/apps/lolcat/log/stderr', true

if ENV.has_key? 'PUMA_REDIRECT_LOGS'
  PUMA_REDIRECT_LOGS = %w(t true yes yea yep on).include?(ENV['PUMA_REDIRECT_LOGS'].downcase)
else
  PUMA_REDIRECT_LOGS = true
end

if PUMA_REDIRECT_LOGS
  stdout_redirect   log_dir + 'puma_stdout.log',
                    log_dir + 'puma_stderr.log',
                    true     # append the output
end


# Disable request logging.
#
# The default is "false".
#
# quiet

quiet


# Configure "min" to be the minimum number of threads to use to answer
# requests and "max" the maximum.
#
# The default is "0, 16".
#
# threads 0, 16

my_mice = [
  Integer(ENV['PUMA_MIN_THREADS'] || 1),
  Integer(ENV['PUMA_MAX_THREADS'] || 4)
]

threads   my_mice.first, my_mice.last



# Bind the server to "url". "tcp://", "unix://" and "ssl://" are the only
# accepted protocols.
#
# The default is "tcp://0.0.0.0:9292".
#
# bind 'tcp://0.0.0.0:9292'
# bind 'unix:///var/run/puma.sock'
# bind 'unix:///var/run/puma.sock?umask=0111'
# bind 'ssl://127.0.0.1:9292?key=path_to_key&cert=path_to_cert'

# If a web instanec has to run in ssl mode, we need to specify the location of SSL cert and its corresponding key
if ENV['PUMA_BIND'].start_with? 'ssl'
  ssl_bind ENV['PUMA_HOST'], ENV['PUMA_PORT'], {
     key: ENV['PUMA_SSL_KEY_PATH'],
     cert: ENV['PUMA_SSL_CERT_PATH']
 }
else
  bind DeapCuiCppPumaUtility.extend_relative_paths_in_puma_bind(ENV['PUMA_BIND'], RAILS_ROOT)
end

# Code to run before doing a restart. This code should
# close log files, database connections, etc.
#
# This can be called multiple times to add code each time.
#
# on_restart do
#   puts 'On restart...'
# end



# Command to use to restart puma. This should be just how to
# load puma itself (ie. 'ruby -Ilib bin/puma'), not the arguments
# to puma, as those are the same as the original process.
#
# restart_command '/u/app/lolcat/bin/restart_puma'



# === Cluster mode ===

# How many worker processes to run.  Typically this is set to
# to the number of available cores.
#
# The default is "0".
#
# workers 2

my_cats = Integer(ENV['PUMA_WORKERS'] || 1)
workers my_cats



# Code to run immediately before the master starts workers.
#
# before_fork do
#   puts "Starting workers..."
# end



# Code to run in a worker before it starts serving requests.
#
# This is called everytime a worker is to be started.
#
# on_worker_boot do
#   puts 'On worker boot...'
# end

# on_worker_boot do
#   # Worker specific setup for Rails 4.1+
#   # See: https://devcenter.heroku.com/articles/deploying-rails-applications-with-the-puma-web-server#on-worker-boot
#   ActiveRecord::Base.establish_connection
# end


# Code to run in a worker right before it exits.
#
# This is called everytime a worker is to about to shutdown.
#
# on_worker_shutdown do
#   puts 'On worker shutdown...'
# end



# Code to run in the master right before a worker is started. The worker's
# index is passed as an argument.
#
# This is called everytime a worker is to be started.
#
# on_worker_fork do
#   puts 'Before worker fork...'
# end



# Code to run in the master after a worker has been started. The worker's
# index is passed as an argument.
#
# This is called everytime a worker is to be started.
#
# after_worker_fork do
#   puts 'After worker fork...'
# end



# Allow workers to reload bundler context when master process is issued
# a USR1 signal. This allows proper reloading of gems while the master
# is preserved across a phased-restart. (incompatible with preload_app)
# (off by default)

# prune_bundler



# Preload the application before starting the workers; this conflicts with
# phased restart feature. (off by default)

# mitigation of slower load times during development environment startup
unless 'development' == ENV['RAILS_ENV']
  preload_app!
end


# Additional text to display in process listing
#
# tag 'app name'
#
# If you do not specify a tag, Puma will infer it. If you do not want Puma
# to add a tag, use an empty string.

tag (RAILS_ROOT.basename).to_s


# Verifies that all workers have checked in to the master process within
# the given timeout. If not the worker process will be restarted. This is
# not a request timeout, it is to protect against a hung or dead process.
# Setting this value will not protect against slow requests.
# Default value is 60 seconds.
#
# worker_timeout 60

worker_timeout Integer(ENV['PUMA_WORKER_TIMEOUT'] || 60)


# Change the default worker timeout for booting
#
# If unspecified, this defaults to the value of worker_timeout.
#
# worker_boot_timeout 60



# === Puma control rack application ===

# Start the puma control rack application on "url". This application can
# be communicated with to control the main server. Additionally, you can
# provide an authentication token, so all requests to the control server
# will need to include that token as a query parameter. This allows for
# simple authentication.
#
# Check out https://github.com/puma/puma/blob/master/lib/puma/app/status.rb
# to see what the app has available.
#
# activate_control_app 'unix:///var/run/pumactl.sock'
# activate_control_app 'unix:///var/run/pumactl.sock', { auth_token: '12345' }
# activate_control_app 'unix:///var/run/pumactl.sock', { no_token: true }


if  1 == $puma_conf_pass    &&    # Puma makes at least two passes through this file or startup
    ARGV.include?('start')  &&    # Only care about this stuff on startup
    !(ARGV.include?('-Q')   ||  ARGV.include?('--quiet'))

  raw_url   = ENV['PUMA_BIND'].split('?').first
  cats_url  = raw_url.gsub('tcp','http').gsub('ssl','https').gsub('0.0.0.0','localhost')

  puts <<~EOS

      Cunning Puma Pounces Crafty Unitarian Invaders ...

                                        #{cats_url}

        ,/|         _.--''^``-...___.._.,;  #{ENV['RAILS_ENV'].upcase}
       /, \\'.     _-'          ,--,,,--'''
      { \\    `_-''       '    /}               Cats: #{my_cats+1}    (aka, process workers + mommy cat)
       `;;'            ;   ; ;                 Mice: #{my_mice.join(':')}  (aka, threads min:max)
   ._.--''     ._,,, _..'  .;.'
    (,_....----'''     (,..--''

  EOS

end # if 1 == $puma_conf_pass  && ...
