#!/usr/bin/env bash
# bin/erd_for_cui.sh

erd  --only_recursion_depth=1 --only ExamRequest, --title "ExamRequest ERD" --filename doc/exam_request_erd

# save current working directory
here=`pwd`

my_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
source $my_dir/check_app_root

doc_dir=$APP_ROOT/doc

cd $APP_ROOT

for model in  Claim Clinic Contention DbqInformation Diagnosis Evaluation Examination ExamRequest FullBodyEvaluation GeneralQuestion MajorSystem MinorSystem QuestionModifier Site Symptom User ; do

  echo
  echo "============================================================"
  echo "Generating ERD for $model ... "

  bundle exec erd \
    --orientation=vertical \
    --cluster \
    --only_recursion_depth=1 \
    --prepend_primary=true \
    --sort=true \
    --direct \
    --title="${model} ERD" \
    --only="${model}," \
    --filename=$doc_dir/${model}_erd --filetype=pdf


done

echo
echo "done"


cd $here

